${header}package ${package}.${defaultDir?lower_case};

import java.util.Set;
import java.util.HashSet;

/**
 * ${table.tableName}テーブルのEntityです。
 * @author S2Dao-CodeGen
 */
<#if timestampPropertyName?exists>@org.seasar.dao.annotation.tiger.Bean(table = "${table.tableName}", timeStampProperty = "${timestampPropertyName}")</#if>
<#if versionNoPropetyName?exists>@org.seasar.dao.annotation.tiger.Bean(table = "${table.tableName}", versionNoProperty = "${versionNoPropetyName}")</#if>
public abstract class Abstract${table.tableNameForDto?cap_first} {

	<#list table.tableField as tableField>
	<#assign fieldName=tableField.fieldNameForDto?uncap_first>
	<#assign javaTypeName=tableField.dataType.langDataType.className>
	<#assign defaultVal=tableField.dataType.langDataType.defVal>
	private ${javaTypeName} ${fieldName}<#if defaultVal?length != 0> = ${defaultVal}</#if>;
	</#list>
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	<#list table.tableField as tableField>
	<#assign propertyName=tableField.fieldNameForDto?cap_first>
	<#assign fieldName=tableField.fieldNameForDto?uncap_first>
	<#assign javaTypeName=tableField.dataType.langDataType.className>
	<#assign fieldAttributeName=tableField.fieldAttributeName>
	<#assign primarys=table.primaryKey>
	/**
	 * ${fieldAttributeName}を返します。
	 * @return ${fieldAttributeName}
	 */
	<#list primarys as primary><#assign primaryName=primary.field.fieldNameForDto?uncap_first>
	<#if primaryName=fieldName>
	<#if primary.field.useIdentity=true>@org.seasar.dao.annotation.tiger.Id(value = org.seasar.dao.annotation.tiger.IdType.IDENTITY)
	<#elseif primary.field.useSequence=true>@org.seasar.dao.annotation.tiger.Id(value = org.seasar.dao.annotation.tiger.IdType.SEQUENCE, sequenceName = "${primary.field.sequence}")
	<#else>@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	</#if>
	</#if>
	</#list>
	@org.seasar.dao.annotation.tiger.Column("${tableField.fieldName}")
	public ${javaTypeName} get${propertyName}() {
		return ${fieldName};
	}

	/**
	 * ${fieldAttributeName}を設定します。
	 * @param ${fieldName} ${fieldAttributeName}
	 */
	public void set${propertyName}(${javaTypeName} ${fieldName}) {
		modifiedPropertySet.add("${fieldName}");
		this.${fieldName} = ${fieldName};
	}

	</#list>

	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		<#list table.tableField as tableField>
		<#assign fieldName=tableField.fieldNameForDto?uncap_first>
		buff.append("/${fieldName}=").append(${fieldName});
		</#list>
		buff.append("]");
		return buff.toString();
	}

}
