/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.convert.impl;

import java.util.List;
import java.util.Map;
import org.seasar.codegen.convert.NameConverter;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverter
implements NameConverter {
    @Override
    public void convert(Map<?, Object> map) {
        for (Object value : map.values()) {
            if (value instanceof Table) {
                this.convertTable((Table)value);
                continue;
            }
            if (value instanceof Map) {
                this.convert((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.convertTable((Table)list.get(i));
            }
        }
    }

    private void convertTable(Table table) {
        table.setTableNameForDto(this.convertClassName(table.getTableName()));
        List<Field> fieldList = table.getTableField();
        for (int i = 0; i < fieldList.size(); ++i) {
            Field field = fieldList.get(i);
            field.setFieldNameForDto(this.convertFieldName(field.getFieldName()));
        }
        List<PrimaryKey> pkList = table.getPrimaryKey();
        for (int i = 0; i < pkList.size(); ++i) {
            PrimaryKey pk = pkList.get(i);
            pk.getField().setFieldNameForDto(this.convertFieldName(pk.getField().getFieldName()));
        }
        List<LinkTable> parentTables = table.getParentTable();
        for (int i = 0; i < parentTables.size(); ++i) {
            LinkTable linkTable = parentTables.get(i);
            linkTable.setParentFieldNameForDto(this.convertFieldName(linkTable.getParentFieldName()));
            linkTable.setTableNameForDto(this.convertClassName(linkTable.getTableName()));
        }
        List<LinkTable> childTables = table.getChildTable();
        for (int i = 0; i < childTables.size(); ++i) {
            LinkTable linkTable = childTables.get(i);
            linkTable.setParentFieldNameForDto(this.convertFieldName(linkTable.getParentFieldName()));
            linkTable.setTableNameForDto(this.convertClassName(linkTable.getTableName()));
        }
    }
}

