/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.util;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * 
 * @author azusa
 * 
 */
public class ToStringUtil {
    private static final ToStringStyle STYLE = new CodeGenToStringStyle();

    private ToStringUtil() {
    }

    public static class CodeGenToStringStyle extends ToStringStyle {

        private static final long serialVersionUID = 1L;

        @Override
        protected void appendIdentityHashCode(StringBuffer arg0, Object arg1) {
        }

        @Override
        protected void appendClassName(StringBuffer arg0, Object arg1) {
        }

        protected void appendFieldEnd(StringBuffer buffer, String fieldName) {
            buffer.append(fieldName);
            buffer.append("\n");
        }

    }

    public static String toString(Object value) {
        return ToStringBuilder.reflectionToString(value, STYLE, false);
    }
}
