/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.dbms;

import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.exception.NotTypeMatchException;

/**
 * Dbms固有の処理を受け持つクラスのインターフェースです。
 * 
 * @author azusa
 * 
 */
public interface Dbms {

    /**
     * DBのタイプ表記をDbmsインターフェースの実装クラス内での内部表記に変換します。
     * 
     * @param typeName
     *            DBのタイプ表記
     * @return 実装クラス内での内部表記。<code>null</code>は返さない
     */
    String convDBTypeToDataType(String typeName);

    /**
     * DBのフィールド設定からデータタイプの表現クラスを求めます。
     * 
     * @param fieldSetting
     *            フィールド設定
     * @return データタイプの表現クラス
     * @throws NotTypeMatchException
     *             タイプ名を解決できない場合。
     */
    DataType selectBestDataType(FieldSetting fieldSetting);

    /**
     * DDLテンプレートのファイル名に付与するためのサフィックスを返します。
     * 
     * @return サフィックス
     */
    String getSuffix();
}
