/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.convert.impl;

import org.seasar.codegen.convert.FKNameConverter;
import org.seasar.codegen.convert.NameConverter;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.Table;

public class FKNameChildNameConverterImpl implements FKNameConverter {

    private NameConverter nameConverter;

    public String convertParent(Table table, LinkTable oneLinkTable) {
        String result = nameConverter.convertFieldName(oneLinkTable
                .getChildFieldName());
        if (result == null) {
            return null;
        }
        if (result.endsWith("ID")) {
            result = result.substring(0, result.length() - 2);
        } else if (result.endsWith("Id")) {
            result = result.substring(0, result.length() - 2);
        } else {
            result = nameConverter.convertClassName(oneLinkTable
                    .getTableNameForDto())
                    + "Entity";
        }

        return result;
    }

    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
    }
}
