/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jiemamy.Jiemamy;
import org.jiemamy.ReferenceResolver;
import org.jiemamy.dialect.BuiltinDataTypeMold;
import org.jiemamy.model.RootModel;
import org.jiemamy.model.attribute.ColumnModel;
import org.jiemamy.model.attribute.ColumnRef;
import org.jiemamy.model.attribute.constraint.ForeignKey;
import org.jiemamy.model.datatype.BuiltinDataType;
import org.jiemamy.model.datatype.adapter.PrecisionedDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.SerialDataTypeAdapter;
import org.jiemamy.model.datatype.adapter.SizedDataTypeAdapter;
import org.jiemamy.model.entity.EntityModel;
import org.jiemamy.model.entity.TableModel;
import org.jiemamy.serializer.JiemamySerializer;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.utils.EntityDependencyCalculator;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.convert.FKNameConverter;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.exception.CodeGenException;
import org.seasar.codegen.util.LinkUtil;
import org.seasar.codegen.util.SequnceUtil;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiemamyImportCodeData
implements ImportCodeData {
    private Dbms dbms;
    private FKNameConverter converter;
    @Binding(bindingType=BindingType.MUST)
    private CodeGenConfig codeGenConfig;

    @Override
    public Map<String, Table> readCodeData(File srcFile) {
        Jiemamy jiemamy = Jiemamy.newInstance();
        JiemamySerializer serializer = jiemamy.getSerializer();
        RootModel rootModel = null;
        try {
            rootModel = serializer.deserialize((InputStream)new FileInputStream(srcFile));
        }
        catch (SerializationException e) {
            throw new CodeGenException("ECDG0004", e);
        }
        catch (FileNotFoundException e) {
            throw new CodeGenException("ECDG0004", e);
        }
        LinkedHashMap<String, Table> tableMap = new LinkedHashMap<String, Table>();
        for (EntityModel entityModel : EntityDependencyCalculator.getSortedEntityList((RootModel)rootModel)) {
            if (!(entityModel instanceof TableModel)) continue;
            TableModel tableModel = (TableModel)entityModel;
            Table table = this.getTable(tableModel, rootModel);
            List<LinkTable> parentLink = this.getParentLink(tableModel, rootModel, table);
            for (LinkTable linkTable : parentLink) {
                String relName = this.converter.convertParent(table, linkTable);
                table.addLinkTable(relName, linkTable);
            }
            tableMap.put(table.getTableName(), table);
        }
        this.setupChildLinks(tableMap);
        return tableMap;
    }

    Table getTable(TableModel tableModel, RootModel rootModel) {
        String tableName = tableModel.getName();
        Table table = new Table();
        table.setTableName(tableName);
        List columnModels = tableModel.findColumns();
        for (ColumnModel columnModel : columnModels) {
            Field field = this.getField(columnModel, rootModel);
            table.addTableField(field);
            PrimaryKey primaryKey = this.getPrimaryKey(columnModel, field);
            if (primaryKey == null) continue;
            table.addPrimaryKey(primaryKey);
        }
        return table;
    }

    Field getField(ColumnModel columnModel, RootModel rootModel) {
        Integer ilength;
        Field field = new Field();
        field.setFieldName(columnModel.getName());
        BuiltinDataType builtinDataType = this.getBuiltinDataType(columnModel);
        BuiltinDataTypeMold mold = null;
        try {
            mold = columnModel.getJiemamy().getDialect(rootModel).getMoldManager().findDataTypeMold(builtinDataType);
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenException("ECDG0004", e);
        }
        FieldSetting fieldSetting = new FieldSetting();
        String langType = this.dbms.convDBTypeToDataType(mold.getName());
        fieldSetting.setTypeName(langType);
        int length = 0;
        if (builtinDataType.hasAdapter(SizedDataTypeAdapter.class) && (ilength = ((SizedDataTypeAdapter)builtinDataType.getAdapter(SizedDataTypeAdapter.class)).getSize()) != null) {
            length = ilength;
        }
        int scale = 0;
        if (builtinDataType.hasAdapter(PrecisionedDataTypeAdapter.class)) {
            length = ((PrecisionedDataTypeAdapter)builtinDataType.getAdapter(PrecisionedDataTypeAdapter.class)).getPrecision();
            Integer iScale = ((PrecisionedDataTypeAdapter)builtinDataType.getAdapter(PrecisionedDataTypeAdapter.class)).getScale();
            if (iScale != null) {
                scale = iScale;
            }
        }
        fieldSetting.setColmnSize(length);
        fieldSetting.setPointNumber(scale);
        fieldSetting.setNotNull(columnModel.getNotNullConstraint() != null);
        if (columnModel.checkPrimaryKeyColumn()) {
            fieldSetting.setNotNull(true);
        }
        fieldSetting.setFieldDefault(columnModel.getDefaultValue() == null ? "" : columnModel.getDefaultValue());
        DataType dataType = this.dbms.selectBestDataType(fieldSetting);
        field.setDataType(dataType);
        if (StringUtil.isEmpty((String)columnModel.getLogicalName())) {
            field.setFieldAttributeName(columnModel.getName());
        } else {
            field.setFieldAttributeName(columnModel.getLogicalName());
        }
        return field;
    }

    private BuiltinDataType getBuiltinDataType(ColumnModel columnModel) {
        ReferenceResolver referenceResolver = columnModel.getJiemamy().getReferenceResolver();
        return columnModel.getDataType().toBuiltinDataType(referenceResolver);
    }

    PrimaryKey getPrimaryKey(ColumnModel columnModel, Field field) {
        if (columnModel.checkPrimaryKeyColumn()) {
            Map<String, String> sequenceMap;
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setField(field);
            if (this.getBuiltinDataType(columnModel).hasAdapter(SerialDataTypeAdapter.class)) {
                field.setUseIdentity(true);
            }
            if ((sequenceMap = this.codeGenConfig.getSequnceMapping()) != null) {
                String sequenceName = sequenceMap.get(columnModel.findDeclaringTable().getName());
                SequnceUtil.addSequence(primaryKey, sequenceName);
            }
            return primaryKey;
        }
        return null;
    }

    List<LinkTable> getParentLink(TableModel tableModel, RootModel rootModel, Table table) {
        List foreignKeys = tableModel.findForeignKeys();
        ArrayList<LinkTable> linkTables = new ArrayList<LinkTable>(foreignKeys.size());
        for (ForeignKey foreignKey : foreignKeys) {
            LinkTable linkTable = new LinkTable();
            linkTable.setChildFieldName(this.findColumn(tableModel, foreignKey.getKeyColumns(), linkTable));
            TableModel parentTable = (TableModel)foreignKey.findReferencedEntity();
            linkTable.setParentFieldName(this.findColumn(parentTable, foreignKey.getReferenceColumns(), linkTable));
            linkTable.setTableName(parentTable.getName());
            linkTables.add(linkTable);
        }
        return linkTables;
    }

    private String findColumn(TableModel tableModel, List<ColumnRef> columnRefs, LinkTable linkTable) {
        for (ColumnRef columnRef : columnRefs) {
            for (ColumnModel columnModel : tableModel.findColumns()) {
                if (!columnModel.getId().equals(columnRef.getReferenceId())) continue;
                return columnModel.getName();
            }
        }
        throw new UnsupportedOperationException();
    }

    private void setupChildLinks(Map<String, Table> tableMap) {
        LinkUtil.setupChildLinks(tableMap);
    }

    public void setFKNameConverter(FKNameConverter converter) {
        this.converter = converter;
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    public void setCodeGenConfig(CodeGenConfig codeGenConfig) {
        this.codeGenConfig = codeGenConfig;
    }
}

