/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.convert.FKNameConverter;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.util.CSVToArrayUtil;
import org.seasar.codegen.util.CreateTableTypeToTypeUtil;
import org.seasar.codegen.util.IdentityUtil;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERWinCSVImportCodeData
implements ImportCodeData {
    private Dbms dbms;
    private FKNameConverter fkNameConverter;
    private static final int TableNamePOS = 0;
    private static final int TableNamaePOS = 1;
    private static final int FieldNamePOS = 2;
    private static final int FieldTypeNamePOS = 3;
    private static final int FieldNullStatePOS = 4;
    private static final int PrimaryKeyPOS = 5;
    private static final int FieldDefaultPOS = 7;
    private static final int ParentRefTypePOS = 8;
    private static final int ParentRefTableNamePOS = 10;
    private static final int ParentRefFieldNamePOS = 11;
    private static final int ChildRefTypePOS = 13;
    private static final int ChildRefTableNamePOS = 14;
    private static final int ChildRefFieldNamePOS = 15;
    private String csvEncode = "MS932";
    @Binding(bindingType=BindingType.MUST)
    private CodeGenConfig codeGenConfig;

    @Override
    public Map<String, Table> readCodeData(File srcFile) {
        List csvArray = CSVToArrayUtil.readCSVToArray(srcFile, this.csvEncode);
        Map<String, Table> tableList = this.csvArrayToTable(csvArray);
        return tableList;
    }

    private Map<String, Table> csvArrayToTable(List csvArray) {
        Iterator ite = csvArray.iterator();
        HashMap<String, Table> tableList = new HashMap<String, Table>();
        Table table = null;
        while (ite.hasNext()) {
            String[] cells = (String[])ite.next();
            table = this.processCSVLine(Arrays.asList(cells), table, tableList);
        }
        return tableList;
    }

    private Table processCSVLine(List<String> oneLine, Table table, Map<String, Table> tableList) {
        if (this.hasTableData(oneLine)) {
            table = new Table();
            String tableName = this.getTableName(oneLine);
            table.setTableName(tableName);
            tableList.put(table.getTableName(), table);
        }
        if (this.hasFieldData(oneLine)) {
            Field field = new Field();
            this.setupField(field, oneLine, table);
            this.setupPrimaryKey(oneLine, field, table);
        }
        this.setupParentRef(oneLine, table);
        this.setupChildRef(oneLine, table);
        return table;
    }

    private void setupChildRef(List<String> oneLine, Table table) {
        if (this.hasChildRef(oneLine)) {
            String tableName = CSVToArrayUtil.getStringFromListPos(oneLine, 14);
            String fieldName = CSVToArrayUtil.getStringFromListPos(oneLine, 15);
            LinkTable linkTable = new LinkTable();
            linkTable.setTableName(tableName);
            linkTable.setParentFieldName(fieldName);
            String relName = this.fkNameConverter.convertParent(table, linkTable);
            table.addChildTable(relName, linkTable);
        }
    }

    private boolean hasChildRef(List<String> oneLine) {
        String data = CSVToArrayUtil.getStringFromListPos(oneLine, 13);
        return data.length() > 0;
    }

    private void setupParentRef(List<String> oneLine, Table table) {
        if (this.hasParentRef(oneLine)) {
            String tableName = CSVToArrayUtil.getStringFromListPos(oneLine, 10);
            String fieldName = CSVToArrayUtil.getStringFromListPos(oneLine, 11);
            LinkTable linkTable = new LinkTable();
            linkTable.setTableName(tableName);
            linkTable.setChildFieldName(fieldName);
            String relName = this.fkNameConverter.convertParent(table, linkTable);
            table.addLinkTable(relName, linkTable);
        }
    }

    private boolean hasParentRef(List<String> oneLine) {
        String data = CSVToArrayUtil.getStringFromListPos(oneLine, 8);
        return data.length() > 0;
    }

    void setupPrimaryKey(List<String> oneLine, Field field, Table table) {
        if (this.hasPrimaryKey(oneLine)) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setField(field);
            if (this.codeGenConfig.getIdentityType() != null) {
                if (IdentityUtil.isIdentityConfig(this.codeGenConfig.getIdentityType())) {
                    field.setUseIdentity(true);
                } else if (IdentityUtil.isSequenceConfig(this.codeGenConfig.getIdentityType())) {
                    field.setSequence(field.getFieldName());
                }
            }
            table.addPrimaryKey(primaryKey);
        }
    }

    boolean hasPrimaryKey(List<String> oneLine) {
        String data = CSVToArrayUtil.getStringFromListPos(oneLine, 5);
        return data.equals("Yes");
    }

    private boolean hasFieldData(List<String> oneLine) {
        String data = CSVToArrayUtil.getStringFromListPos(oneLine, 2);
        return data.length() != 0;
    }

    private void setupField(Field field, List<String> oneLine, Table table) {
        this.setupFieldDataType(field, oneLine);
        String fieldName = CSVToArrayUtil.getStringFromListPos(oneLine, 2);
        field.setFieldName(fieldName);
        field.setFieldAttributeName(fieldName);
        table.addTableField(field);
    }

    private void setupFieldDataType(Field field, List<String> oneLine) {
        String fieldTypeName = CSVToArrayUtil.getStringFromListPos(oneLine, 3);
        String fieldNullState = CSVToArrayUtil.getStringFromListPos(oneLine, 4);
        String fieldDefault = CSVToArrayUtil.getStringFromListPos(oneLine, 7);
        DataType type = this.selectDataType(fieldNullState, fieldTypeName, fieldDefault);
        field.setDataType(type);
    }

    private DataType selectDataType(String fieldNullState, String fieldTypeName, String fieldDefault) {
        FieldSetting fieldSetting = new FieldSetting();
        String typeName = CreateTableTypeToTypeUtil.getTypeName(fieldTypeName);
        String dataType = this.dbms.convDBTypeToDataType(typeName);
        fieldSetting.setTypeName(dataType);
        String length = CreateTableTypeToTypeUtil.getLength(fieldTypeName, typeName);
        int fullLength = CreateTableTypeToTypeUtil.getFullLength(length);
        fieldSetting.setColmnSize(fullLength);
        int pointNumberLength = CreateTableTypeToTypeUtil.getPointNumberLength(length);
        fieldSetting.setPointNumber(pointNumberLength);
        boolean isNotNull = fieldNullState.equals("NOT NULL");
        fieldSetting.setNotNull(isNotNull);
        fieldSetting.setFieldDefault(fieldDefault);
        DataType type = this.dbms.selectBestDataType(fieldSetting);
        return type;
    }

    private boolean hasTableData(List<String> oneLine) {
        String data = CSVToArrayUtil.getStringFromListPos(oneLine, 1);
        return data.length() != 0;
    }

    private String getTableName(List<String> oneLine) {
        String data = CSVToArrayUtil.getStringFromListPos(oneLine, 0);
        return data;
    }

    public Dbms getDataTypeSelectUtil() {
        return this.dbms;
    }

    public void setDataTypeSelectUtil(Dbms dataTypeSelectUtil) {
        this.dbms = dataTypeSelectUtil;
    }

    public String getCsvEncode() {
        return this.csvEncode;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setCsvEncode(String csvEncode) {
        this.csvEncode = csvEncode;
    }

    public FKNameConverter getFkNameConverter() {
        return this.fkNameConverter;
    }

    public void setFKNameConverter(FKNameConverter fkNameConverter) {
        this.fkNameConverter = fkNameConverter;
    }

    public void setCodeGenConfig(CodeGenConfig codeGenConfig) {
        this.codeGenConfig = codeGenConfig;
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }
}

