/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.ant;

import java.io.File;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.DDL;
import org.seasar.codegen.Java;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.Resource;
import org.seasar.codegen.ant.Directory;
import org.seasar.codegen.ant.DirectoryList;
import org.seasar.codegen.ant.EachGen;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.exception.SRuntimeException;

public class CodeGenMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        SingletonS2ContainerFactory.setConfigPath((String)"app_gen.dicon");
        SingletonS2ContainerFactory.init();
        S2Container s2 = SingletonS2ContainerFactory.getContainer();
        try {
            s2.init();
            ComponentDef[] components = s2.findAllComponentDefs(OutputCode.class);
            DirectoryList list = (DirectoryList)s2.getComponent((Object)"path");
            for (ComponentDef componentDef : components) {
                OutputCode outputCode = (OutputCode)componentDef.getComponent();
                if (outputCode.getClass().isAnnotationPresent(Java.class)) {
                    this.doGenarate(s2, outputCode, list.getDirectory("java"));
                    continue;
                }
                if (outputCode.getClass().isAnnotationPresent(Resource.class)) {
                    this.doGenarate(s2, outputCode, list.getDirectory("resource"));
                    continue;
                }
                if (outputCode.getClass().isAnnotationPresent(DDL.class)) {
                    this.doGenarate(s2, outputCode, list.getDirectory("createtable"));
                    continue;
                }
                throw new SRuntimeException("ECDG0003", new Object[]{outputCode.getClass()});
            }
        }
        finally {
            s2.destroy();
        }
    }

    protected void doGenarate(S2Container s2, OutputCode outputCode, Directory directory) {
        EachGen eachGen = new EachGen();
        CodeGenConfig codeGenConfig = (CodeGenConfig)s2.getComponent(CodeGenConfig.class);
        eachGen.setContainer(s2);
        eachGen.setCsvFile(new File(codeGenConfig.getInputFile()));
        eachGen.setDestinationDir(new File(directory.getDestination()));
        eachGen.setOutputCode(outputCode);
        eachGen.generate();
    }
}

