${header}package ${package}.dao;

import java.util.List;

import ${package}.entity.${table.tableNameForDto?cap_first};
import ${package}.condition.${table.tableNameForDto?cap_first}Condition;
<#assign parent=table.parentTable>
<#if parent?size != 0>
import ${package}.entity.${table.tableNameForDto?cap_first}Relation;
import ${package}.condition.${table.tableNameForDto?cap_first}RelationCondition;
</#if>
/**
 * ${table.tableName}テーブルに対応するDaoの中核部分です。
 * このDaoはgeneration gapを使用しているので、処理を追加するときは${table.tableNameForDto?cap_first}Daoに処理を記述します。
 * @author S2Dao-CodeGen
 */
@org.seasar.dao.annotation.tiger.S2Dao(bean = ${table.tableNameForDto?cap_first}.class)
@org.seasar.codegen.lib.annotation.SqlFileEncoding("${encoding}")
public interface ${table.tableNameForDto?cap_first}Core {

	<#assign primarys=table.primaryKey>
	<#if primarys?size = 1 ><#assign primaryField=primarys?first></#if>
	/**
	 * ${table.tableName}のEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	<#if primarys?size = 1 >@org.seasar.dao.annotation.tiger.Query("ORDER BY ${primaryField.field.fieldName}")</#if>
	public List<${table.tableNameForDto?cap_first}> getAll${table.tableNameForDto?cap_first}();


	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	<#assign javaTypeName=primaryField.field.dataType.langDataType.className>
	/**
	 * 引数が主キーと一致する${table.tableName}のEntityを取得します。
	 *
	 * @param ${primaryField.field.fieldNameForDto} 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("${primaryField.field.fieldName} = ?")
	public ${table.tableNameForDto?cap_first} get${table.tableNameForDto?cap_first}(${javaTypeName} ${primaryField.field.fieldNameForDto});
	</#if>

	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	<#assign javaTypeName=primaryField.field.dataType.langDataType.className>

	/**
	 * 引数が主キーと一致する${table.tableName}のEntityのリストを主キーでソートして取得します。
	 *
	 * @param ${primaryField.field.fieldNameForDto?uncap_first}s  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("${primaryField.field.fieldNameForDto}s")
	@org.seasar.dao.annotation.tiger.Query("${primaryField.field.fieldName} in /*${primaryField.field.fieldNameForDto?uncap_first}s*/(1) ORDER BY ${primaryField.field.fieldName}")
	public List<${table.tableNameForDto?cap_first}> get${table.tableNameForDto?cap_first}ByIds(${javaTypeName} ... ${primaryField.field.fieldNameForDto?uncap_first}s);
	</#if>
	

	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<${table.tableNameForDto?cap_first}> find(${table.tableNameForDto?cap_first}Condition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityに対応するDto。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public ${table.tableNameForDto?cap_first} soleMatch(${table.tableNameForDto?cap_first}Condition condition);

<#if parent?size != 0>
	<#assign primarys=table.primaryKey>

	/**
	 * ${table.tableName}のEntityを関連先も含めて全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	<#if primarys?size = 1 ><#assign primaryField=primarys?first>@org.seasar.dao.annotation.tiger.Query("ORDER BY ${primaryField.field.fieldName}")</#if>
	public List<${table.tableNameForDto?cap_first}Relation> getAll${table.tableNameForDto?cap_first}WithRelation();


	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	<#assign javaTypeName=primaryField.field.dataType.langDataType.className>
	/**
	 * 引数が主キーと一致する${table.tableName}のEntityを関連先も含めて取得します。
	 *
	 * @param ${primaryField.field.fieldNameForDto} 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("${primaryField.field.fieldName?cap_first}  = ? ORDER BY ${primaryField.field.fieldName}")
	public ${table.tableNameForDto?cap_first}Relation get${table.tableNameForDto?cap_first}WithRelation(${javaTypeName} ${primaryField.field.fieldNameForDto?uncap_first});
	</#if>


	<#if primarys?size = 1 >
	<#assign primaryField=primarys?first>
	<#assign primaryName=primaryField.field.fieldName?uncap_first>
	<#assign javaTypeName=primaryField.field.dataType.langDataType.className>
	/**
	 * 引数が主キーと一致する${table.tableName}のEntityのリストを関連先も含めて主キーでソートして取得します。
	 *
	 * @param ${primaryField.field.fieldNameForDto?uncap_first}s  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("${primaryField.field.fieldNameForDto?uncap_first}s")
	@org.seasar.dao.annotation.tiger.Query("${primaryField.field.fieldName} in /*${primaryField.field.fieldNameForDto?uncap_first}s*/(1) ORDER BY ${primaryField.field.fieldName}")
	public List<${table.tableNameForDto?cap_first}Relation> get${table.tableNameForDto?cap_first}ByIdsWithRelation(Object ... ${primaryField.field.fieldNameForDto?uncap_first}s);
	</#if>
	
	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<${table.tableNameForDto?cap_first}Relation> findWithRelation(${table.tableNameForDto?cap_first}RelationCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public ${table.tableNameForDto?cap_first}Relation soleMatchWithRelation(${table.tableNameForDto?cap_first}RelationCondition condition);
</#if>
<#if table.view = false>
	/**
	 * Entityを追加します。
	 *
	 * @param entity 追加するEntity
	 */
	public void insert(${table.tableNameForDto?cap_first} entity);
</#if>
	<#if (primarys?size > 0) >
	/**
	 * Entityを更新します。
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void update(${table.tableNameForDto?cap_first} entity);

	/**
	 * Entityを削除します。
	 *
	 * @param entity 削除するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void delete(${table.tableNameForDto?cap_first} entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します.	 
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void updateModifiedOnly(${table.tableNameForDto?cap_first} entity);

	/**
	 * Entityを更新します。このメソッドは更新結果が0件の時例外を投げません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	 @org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	 public int updateNonCheck(${table.tableNameForDto?cap_first} entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します。このメソッドは更新結果が0件の時例外を返しません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	@org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	public int updateNonCheckModifiedOnly(${table.tableNameForDto?cap_first} entity);
	</#if>
<#if table.view = false>
	/**
	 * 追加をバッチ更新で行います。
	 * @param entityList 追加するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] insertBatch(List<${table.tableNameForDto?cap_first}> entityList);
</#if>
	<#if (primarys?size > 0) >
	/**
	 * 更新をバッチ更新で行います。
	 * @param entityList 更新するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] updateBatch(List<${table.tableNameForDto?cap_first}> entityList);

	/**
	 * 削除をバッチ更新で行います。
	 * @param EntityList 削除するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] deleteBatch(List<${table.tableNameForDto?cap_first}> entityList);
	</#if>

}

