<#list tableList as table>


CREATE TABLE ${table.tableName} (
	<#assign primarys=table.primaryKey>

	<#assign conma = "">
	<#list table.tableField as tableField>
		<#assign fieldName=tableField.fieldName>
		<#assign fieldDataType=tableField.dataType>
		<#assign rdbDataType=fieldDataType.rdbTypeName>
		<#assign IsNotNull=fieldDataType.isNotNullString>
		<#assign colmnSize="("+fieldDataType.colmnSize+")">
		<#assign colmnSizePoint="("+fieldDataType.colmnSize+"."+fieldDataType.pointNumber+")">
		${conma}
		<#if colmnSize == "(0)">
			<#assign colmnSize = "">
		<#else>
			<#assign colmnSizePoint = "">
		</#if>
		<#if colmnSizePoint == "(0.0)">
			<#assign colmnSizePoint = "">
		</#if>
		<#if (primarys?size > 0) && (fieldName == primarys?first.field.fieldName) >
			<#assign primaryField = primarys?first.field>
       ${fieldName}           ${rdbDataType}${colmnSize}${colmnSizePoint} ${IsNotNull}
				<#if table.primaryKey?size=1>
					<#if primaryField.useIdentity == true >
				AUTO_INCREMENT(1,1)
					</#if>
				PRIMARY KEY
				</#if>
		<#else>
       ${fieldName}              ${rdbDataType}${colmnSize}${colmnSizePoint} ${IsNotNull}
        </#if>
		<#assign conma = ",">        
	</#list>
);

<#assign primaryKey=table.primaryKey>
<#if primaryKey?size = 1>
<#if primaryKey?first.field.useSequence == true >
--CREATE SEQUENCE ${primaryKey?first.field.sequence}
-- START WITH 1
-- INCREMENT BY 1
--;
</#if>
</#if>

</#list>

<#list tableList as table>
	<#list table.parentTable as linkTable>
		<#assign fkName=linkTable.childFieldName>
		ALTER TABLE ${table.tableName} 
			ADD CONSTRAINT FK_${table.tableName}_${fkName} FOREIGN KEY(${fkName}) 
			REFERENCES ${linkTable.tableName}(${linkTable.parentFieldName})
	</#list>
</#list>
