/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.util.Map;
import org.seasar.codegen.CodeGenerator;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.exception.NotFileException;

public class CodeGeneratorImpl
implements CodeGenerator {
    private ImportCodeData codeData;
    private OutputCode outputCode;

    public void generate(String srcData, String baseDir) {
        File src = new File(srcData);
        File base = new File(baseDir);
        if (!src.canRead()) {
            throw new NotFileException(srcData);
        }
        this.generate(src, base);
    }

    public void generate(File srcFile, File baseDir) {
        Map<String, Table> tableList = this.codeData.readCodeData(srcFile);
        this.outputCode.generateCode(baseDir, tableList);
    }

    public ImportCodeData getCodeData() {
        return this.codeData;
    }

    public void setCodeData(ImportCodeData codeData) {
        this.codeData = codeData;
    }

    public OutputCode getOutputCode() {
        return this.outputCode;
    }

    public void setOutputCode(OutputCode outputCode) {
        this.outputCode = outputCode;
    }
}

