/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.seasar.buri.common.util.template.TextTemplate;
import org.seasar.buri.common.util.template.exception.TemplateRuntimeException;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.Java;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.convert.NameConverter;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.impl.CodeGenConfigImpl;
import org.seasar.codegen.templates.LoaderClass;
import org.seasar.codegen.util.FileUtil;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Java
public class AbstractEntityOutputCodeImpl
implements OutputCode {
    protected String defaultDir = "Entity";
    protected String dirNameFtl = "${package?replace(\".\",\"/\")}/${defaultDir?lower_case?replace(\".\",\"/\")}/";
    protected String fileNameFtl = "Abstract${table.tableNameForDto?cap_first}.java";
    protected String templateFileName = "abstractEntity.ftl";
    private Map<String, Object> addRootObj = new HashMap<String, Object>();
    protected TextTemplate template;
    private NameConverter converter;
    protected CodeGenConfig codegenConfig = new CodeGenConfigImpl();
    protected boolean useGenerationGap = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCode(File baseDir, Map<String, Table> tableList) {
        Configuration cfg = this.getConfiguration();
        for (String key : tableList.keySet()) {
            Map<String, Object> root = this.createRootObj(tableList, key);
            this.convetName(root);
            Writer out = null;
            try {
                out = this.createWriter(baseDir, root);
                if (out == null) continue;
                this.processTemplate(cfg, root, out);
            }
            finally {
                this.destroyWriter(out);
            }
        }
    }

    protected void destroyWriter(Writer out) {
        try {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void processTemplate(Configuration cfg, Map<String, Object> root, Writer out) {
        Template temp = this.createTemplate(cfg);
        try {
            temp.process(root, out);
        }
        catch (TemplateException e) {
            throw new TemplateRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected Writer createWriter(File baseDir, Map<String, Object> root) {
        String outputDirName = baseDir.getPath() + File.separator + this.template.process(this.dirNameFtl, root);
        String outputFileName = this.template.process(this.fileNameFtl, root);
        OutputStreamWriter writer = null;
        try {
            new File(outputDirName).mkdirs();
            File dist = new File(outputDirName + outputFileName);
            if (this.useGenerationGap && dist.exists()) {
                return null;
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(dist), this.codegenConfig.getEncoding());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return writer;
    }

    protected Template createTemplate(Configuration cfg) {
        Template temp = null;
        try {
            temp = cfg.getTemplate(this.templateFileName);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return temp;
    }

    protected Map<String, Object> createRootObj(Map<String, Table> tableList, String key) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("table", tableList.get(key));
        root.put("package", this.codegenConfig.getPackageName());
        root.put("defaultDir", this.defaultDir);
        root.put("encoding", this.codegenConfig.getEncoding());
        root.putAll(this.addRootObj);
        if (!StringUtil.isEmpty((String)this.codegenConfig.getHeaderTemplatePath())) {
            root.put("header", FileUtil.readText(this.codegenConfig.getHeaderTemplatePath(), this.codegenConfig.getEncoding()));
        } else {
            root.put("header", "");
        }
        if (this.codegenConfig.isTimestamp()) {
            root.put("timestampPropertyName", this.codegenConfig.getTimestampPropertyName());
        }
        if (this.codegenConfig.isVersionNo()) {
            root.put("versionNoPropetyName", this.codegenConfig.getVersionNoPropertyName());
        }
        return root;
    }

    protected void convetName(Map<String, Object> root) {
        this.converter.convert(root);
    }

    protected Configuration getConfiguration() {
        Configuration cfg = new Configuration();
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(LoaderClass.class, "/org/seasar/codegen/templates"));
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setDefaultEncoding("UTF-8");
        return cfg;
    }

    public void addRootObjct(String name, Object data) {
        this.addRootObj.put(name, data);
    }

    public String getDefaultDir() {
        return this.defaultDir;
    }

    public void setDefaultDir(String defaultDir) {
        this.defaultDir = defaultDir;
    }

    public String getFileNameFtl() {
        return this.fileNameFtl;
    }

    public void setFileNameFtl(String fileNameFtl) {
        this.fileNameFtl = fileNameFtl;
    }

    public TextTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(TextTemplate template) {
        this.template = template;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public void setDirNameFtl(String dirNameFtl) {
        this.dirNameFtl = dirNameFtl;
    }

    @Override
    @Binding(bindingType=BindingType.MAY)
    public void setNameConverter(NameConverter converter) {
        this.converter = converter;
    }

    @Override
    @Binding(bindingType=BindingType.MAY)
    public void setCodegenConfig(CodeGenConfig codegenConfig) {
        this.codegenConfig = codegenConfig;
    }

    public boolean isUseGenerationGap() {
        return this.useGenerationGap;
    }

    public void setUseGenerationGap(boolean useGenerationGap) {
        this.useGenerationGap = useGenerationGap;
    }
}

