/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.ant;

import java.io.File;

import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.DDL;
import org.seasar.codegen.Java;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.Resource;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.exception.SRuntimeException;

/**
 * メイン処理用のクラスです。
 * 
 * @author azusa
 * 
 */
public class CodeGenMain {

    /**
     * メイン処理です。
     */
    public void execute() {

        SingletonS2ContainerFactory.setConfigPath("app_gen.dicon");
        SingletonS2ContainerFactory.init();
        S2Container s2 = SingletonS2ContainerFactory.getContainer();
        try {
            s2.init();
            ComponentDef[] components = s2
                    .findAllComponentDefs(OutputCode.class);
            DirectoryList list = (DirectoryList) s2.getComponent("path");

            for (ComponentDef componentDef : components) {
                OutputCode outputCode = (OutputCode) componentDef
                        .getComponent();
                if (outputCode.getClass().isAnnotationPresent(Java.class)) {
                    doGenarate(s2, outputCode, list.getDirectory("java"));
                } else if (outputCode.getClass().isAnnotationPresent(
                        Resource.class)) {
                    doGenarate(s2, outputCode, list.getDirectory("resource"));
                } else if (outputCode.getClass().isAnnotationPresent(DDL.class)) {
                    doGenarate(s2, outputCode, list.getDirectory("createtable"));
                } else {
                    throw new SRuntimeException("ECDG0003",
                            new Object[] { outputCode.getClass() });
                }

            }

        } finally {
            s2.destroy();
        }
    }

    protected void doGenarate(S2Container s2, OutputCode outputCode,
            Directory directory) {
        EachGen eachGen = new EachGen();
        CodeGenConfig codeGenConfig = (CodeGenConfig) s2
                .getComponent(CodeGenConfig.class);
        eachGen.setContainer(s2);
        eachGen.setCsvFile(new File(codeGenConfig.getInputFile()));
        eachGen.setDestinationDir(new File(directory.getDestination()));
        // eachGen.setPackageName(codeGenConfig.getPackageName());
        eachGen.setOutputCode(outputCode);
        eachGen.generate();
    }
}
