${header}package ${package}.${defaultDir?lower_case};

<#assign parentTables=table.parentTableName>
<#assign tableNames = parentTables?keys>

/**
 * テーブル${table.tableName}とマッピング関係にあるテーブルに対応するDtoです。
 * @author S2Dao-CodeGen
 */
public abstract class Abstract${table.tableNameForDto?cap_first}Relation extends Abstract${table.tableNameForDto?cap_first} {

<#list tableNames as tableName>
	<#assign parentTable=parentTables[tableName]>
	private ${parentTable.tableNameForDto?cap_first} ${tableName?uncap_first};
	
</#list>

<#list tableNames as tableName>
	<#assign parentTable=parentTables[tableName]>
	/**
	 * ${parentTable.tableName}に対応するEntityを返します。
	 * @return ${parentTable.tableName}に対応するEntity
	 */
	<#list tableNames as tableName2>
	<#assign childFieldName=parentTable.childFieldNameForDto><#assign parentTableData=tableMap[parentTable.tableName]><#assign parentTablePkey=parentTableData.primaryKey?first.field.fieldName>
	<#if tableName2=tableName>
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "${childFieldName}:${parentTablePkey}", relationNo = ${tableName_index})
	</#if>
	</#list>
	public ${parentTable.tableNameForDto?cap_first} get${tableName?cap_first}() {
		return this.${tableName?uncap_first};
	}

	/**
	 * ${parentTable.tableName}に対応するDtoを設定します。
	 * @param ${tableName?uncap_first} ${parentTable.tableName}に対応するEntity
	 */
	public void set${tableName?cap_first}(${parentTable.tableNameForDto?cap_first} ${tableName?uncap_first}) {
		this.${tableName?uncap_first} = ${tableName?uncap_first};
	}
</#list>

	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append(super.toString());
<#list tableNames as tableName>
	<#assign parentTable=parentTables[tableName]>
		buf.append("${tableName?uncap_first}").append(${tableName?uncap_first});
</#list>
		return buf.toString();
	}

}
