/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.seasar.codegen.util.ToStringUtil;

public class Table {
    private String tableName;

    private String tableNameForDto;

    private List<PrimaryKey> primaryKey = new ArrayList<PrimaryKey>();

    private List<Field> tableField = new ArrayList<Field>();

    private Map<String, Field> fieldMap = new HashMap<String, Field>();

    private List<LinkTable> parentTable = new ArrayList<LinkTable>();

    private Map<String, LinkTable> parentTableName = new HashMap<String, LinkTable>();

    private List<LinkTable> childTable = new ArrayList<LinkTable>();

    private Map<String, LinkTable> childTableName = new HashMap<String, LinkTable>();

    private List<TableValidator> validator = new ArrayList<TableValidator>();

    private boolean view = false;

    public List<LinkTable> getChildTable() {
        return childTable;
    }

    public void setChildTable(List<LinkTable> childTable) {
        this.childTable = childTable;
    }

    public void addChildTable(LinkTable oneChildTable) {
        childTable.add(oneChildTable);
    }

    public Map<String, LinkTable> getChildTableName() {
        return childTableName;
    }

    public void setChildTableName(Map<String, LinkTable> childTableName) {
        this.childTableName = childTableName;
    }

    public void addChildTable(String name, LinkTable oneChildTable) {
        childTable.add(oneChildTable);
        childTableName.put(name, oneChildTable);
    }

    public Map<String, LinkTable> getParentTableName() {
        return parentTableName;
    }

    public void setParentTableName(Map<String, LinkTable> parentTableName) {
        this.parentTableName = parentTableName;
    }

    public void addLinkTable(String name, LinkTable oneLinkTable) {
        parentTable.add(oneLinkTable);
        parentTableName.put(name, oneLinkTable);
    }

    public List<LinkTable> getParentTable() {
        return parentTable;
    }

    public void setParentTable(List<LinkTable> linkTable) {
        this.parentTable = linkTable;
    }

    public void addLinkTable(LinkTable oneLinkTable) {
        parentTable.add(oneLinkTable);
    }

    public List<PrimaryKey> getPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(List<PrimaryKey> primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void addPrimaryKey(PrimaryKey onePrimaryKey) {
        primaryKey.add(onePrimaryKey);
    }

    public List<Field> getTableField() {
        return tableField;
    }

    public void setTableField(List<Field> tableField) {
        this.tableField = tableField;
    }

    public void addTableField(Field oneTableField) {
        tableField.add(oneTableField);
        fieldMap.put(oneTableField.getFieldName(), oneTableField);
    }

    public Field getTableField(String firldName) {
        return fieldMap.get(firldName);
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<TableValidator> getValidator() {
        return validator;
    }

    public void setValidator(List<TableValidator> validator) {
        this.validator = validator;
    }

    public void addValidator(TableValidator oneTableValidator) {
        validator.add(oneTableValidator);
    }

    public String getTableNameForDto() {
        if (tableNameForDto == null) {
            return tableName;
        }
        return tableNameForDto;
    }

    public void setTableNameForDto(String tableNameForDto) {
        this.tableNameForDto = tableNameForDto;
    }

    public String toString() {
        return ToStringUtil.toString(this);
    }

    /**
     * Entityがビューかを返します。
     * 
     * @return ビューの時は<code>true</code>
     */
    public boolean isView() {
        return view;
    }

    /**
     * Entityがビューかを設定します。
     * 
     * @param view
     *            ビューの時は<code>true</code>
     */
    public void setView(boolean view) {
        this.view = view;
    }
}
