/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.util;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.seasar.codegen.exception.FileNotFoundRuntimeException;
import org.seasar.codegen.exception.UnsupportedEncodingRuntimeException;
import org.seasar.framework.exception.IORuntimeException;

public class CSVToArrayUtil {
    public static List readCSVToArray(File srcFile, String encode) {
        BufferedReader bufferedreader = CSVToArrayUtil.getBufferedReader(srcFile, encode);
        CSVToArrayUtil.readLine(bufferedreader);
        CSVReader reader = new CSVReader((Reader)bufferedreader);
        try {
            return reader.readAll();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static BufferedReader getBufferedReader(File srcFile, String encode) {
        InputStreamReader inputReader = null;
        try {
            String srcFileName = srcFile.getPath();
            FileInputStream fis = new FileInputStream(srcFileName);
            inputReader = new InputStreamReader((InputStream)fis, encode);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundRuntimeException(srcFile, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingRuntimeException(srcFile, e);
        }
        BufferedReader bufferedreader = new BufferedReader(inputReader);
        return bufferedreader;
    }

    private static String readLine(BufferedReader bufferedreader) {
        String buff;
        try {
            buff = bufferedreader.readLine();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return buff;
    }

    public static String getStringFromListPos(List oneLine, int pos) {
        if (oneLine.size() <= pos) {
            return "";
        }
        return (String)oneLine.get(pos);
    }
}

