/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.codegen.convert.FKNameConverter;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.impl.ExcelImportCodeDataSupport;
import org.seasar.codegen.util.ExcelUtil;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelImportCodeDataSingleSheet
extends ExcelImportCodeDataSupport {
    protected int entityNameCol = 0;
    protected int tableNameCol = 1;

    public ExcelImportCodeDataSingleSheet() {
        this.attributeNameCol = 2;
        this.columnNameCol = 3;
        this.dataTypeCol = 4;
        this.notNullCol = 5;
        this.primaryKeyCol = 6;
        this.foreignKeyCol = 7;
        this.defaultValueCol = 8;
        this.relationTypeCol = 9;
        this.parentTableCol = 10;
        this.parentColumnCol = 11;
        this.cardinalityCol = 12;
        this.parentPropertyCol = 13;
        this.childPropertyCol = 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Table> readCodeData(File srcFile) {
        InputStream in = FileInputStreamUtil.create((File)srcFile);
        try {
            Map<String, Table> tableMap;
            in = new BufferedInputStream(in);
            HSSFWorkbook book = ExcelUtil.createWorkbook(in);
            HSSFSheet sheet = book.getSheetAt(0);
            Map<String, Table> map = tableMap = this.readCodeData(sheet);
            return map;
        }
        finally {
            InputStreamUtil.close((InputStream)in);
        }
    }

    protected Map<String, Table> readCodeData(HSSFSheet sheet) {
        LinkedHashMap<String, Table> tableMap = new LinkedHashMap<String, Table>();
        Table table = null;
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            HSSFRow row = sheet.getRow(i);
            table = this.processRow(row, table, tableMap);
        }
        this.setupChildLinks(tableMap);
        return tableMap;
    }

    protected Table processRow(HSSFRow row, Table table, Map<String, Table> tableMap) {
        Field field;
        String tableName = this.getString(row, this.tableNameCol);
        if (!StringUtil.isEmpty((String)tableName)) {
            table = new Table();
            table.setTableName(tableName);
            tableMap.put(table.getTableName(), table);
        }
        if ((field = this.getField(row)) != null) {
            LinkTable parentLink;
            table.addTableField(field);
            PrimaryKey primaryKey = this.getPrimaryKey(row, field);
            if (primaryKey != null) {
                table.addPrimaryKey(primaryKey);
            }
            if ((parentLink = this.getParentLink(row, field)) != null) {
                String relName = this.converter.convertParent(table, parentLink);
                table.addLinkTable(relName, parentLink);
            }
        }
        return table;
    }

    public void setConverter(FKNameConverter converter) {
        this.converter = converter;
    }
}

