/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.web.DbColumn;
import org.h2.web.DbSchema;

public class DbTableOrView {
    DbSchema schema;
    String name;
    String quotedName;
    boolean isView;
    DbColumn[] columns;

    DbTableOrView(DbSchema schema, ResultSet rs) throws SQLException {
        this.schema = schema;
        this.name = rs.getString("TABLE_NAME");
        String type = rs.getString("TABLE_TYPE");
        this.isView = "VIEW".equals(type);
        this.quotedName = schema.contents.quoteIdentifier(this.name);
    }

    public void readColumns(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = meta.getColumns(null, this.schema.name, this.name, null);
        ArrayList<DbColumn> list = new ArrayList<DbColumn>();
        while (rs.next()) {
            DbColumn column = new DbColumn(rs);
            list.add(column);
        }
        rs.close();
        this.columns = new DbColumn[list.size()];
        list.toArray(this.columns);
    }
}

