/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueByte
extends Value {
    public static final int PRECISION = 3;
    private byte value;

    private ValueByte(byte value) {
        this.value = value;
    }

    public Value add(Value v) throws SQLException {
        ValueByte other = (ValueByte)v;
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(this.value + other.value);
        }
        return ValueByte.get((byte)(this.value + other.value));
    }

    private ValueByte checkRange(int value) throws SQLException {
        if (value < -128 || value > 127) {
            throw Message.getSQLException(90110, DataType.getDataType((int)2).name);
        }
        return ValueByte.get((byte)value);
    }

    public int getSignum() {
        return this.value == 0 ? 0 : (this.value < 0 ? -1 : 1);
    }

    public Value negate() throws SQLException {
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(-this.value);
        }
        return ValueByte.get(-this.value);
    }

    public Value subtract(Value v) throws SQLException {
        ValueByte other = (ValueByte)v;
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(this.value - other.value);
        }
        return ValueByte.get((byte)(this.value - other.value));
    }

    public Value multiply(Value v) throws SQLException {
        ValueByte other = (ValueByte)v;
        if (Constants.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(this.value * other.value);
        }
        return ValueByte.get((byte)(this.value * other.value));
    }

    public Value divide(Value v) throws SQLException {
        ValueByte other = (ValueByte)v;
        if (other.value == 0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value / other.value));
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 2;
    }

    public byte getByte() {
        return this.value;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueByte v = (ValueByte)o;
        if (this.value == v.value) {
            return 0;
        }
        return this.value > v.value ? 1 : -1;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 3L;
    }

    public int hashCode() {
        return this.value;
    }

    public Object getObject() {
        return new Byte(this.value);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setByte(parameterIndex, this.value);
    }

    public static ValueByte get(byte i) {
        return (ValueByte)Value.cache(new ValueByte(i));
    }

    public int getDisplaySize() {
        return 3;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueByte && this.value == ((ValueByte)v).value;
    }
}

