/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.HashCursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.util.IntIntHashMap;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class HashIndex
extends Index {
    private ValueHashMap rows;
    private IntIntHashMap intMap;
    private TableData tableData;

    public HashIndex(TableData table, int id, String indexName, Column[] columns, IndexType indexType) {
        super(table, id, indexName, columns, indexType);
        this.tableData = table;
        this.reset();
    }

    private void reset() {
        if (this.columns.length == 1 && this.columns[0].getType() == 4) {
            this.intMap = new IntIntHashMap();
        } else {
            this.rows = new ValueHashMap(this.table.getDatabase());
        }
    }

    public void close(Session session) {
    }

    public void truncate(Session session) throws SQLException {
        this.reset();
    }

    public void remove(Session session) throws SQLException {
    }

    public void add(Session session, Row row) throws SQLException {
        if (this.intMap != null) {
            int key = row.getValue(this.columns[0].getColumnId()).getInt();
            this.intMap.put(key, row.getPos());
        } else {
            Value key = this.getKey(row);
            Object old = this.rows.get(key);
            if (old != null) {
                throw this.getDuplicateKeyException();
            }
            Integer pos = new Integer(row.getPos());
            this.rows.put(this.getKey(row), pos);
        }
        ++this.rowCount;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.intMap != null) {
            int key = row.getValue(this.columns[0].getColumnId()).getInt();
            this.intMap.remove(key);
        } else {
            this.rows.remove(this.getKey(row));
        }
        --this.rowCount;
    }

    private Value getKey(Row row) {
        if (this.columns.length == 1) {
            Column column = this.columns[0];
            int index = column.getColumnId();
            Value v = row.getValue(index);
            return v;
        }
        Value[] list = new Value[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int index = column.getColumnId();
            list[i] = row.getValue(index);
        }
        return ValueArray.get(list);
    }

    public Cursor find(Session session, Row first, Row last) throws SQLException {
        Integer pos;
        int key;
        int pos2;
        if (first == null || last == null) {
            throw Message.internal();
        }
        Row result = this.intMap != null ? ((pos2 = this.intMap.get(key = first.getValue(this.columns[0].getColumnId()).getInt())) != -1 ? this.tableData.getRow(pos2) : null) : ((pos = (Integer)this.rows.get(this.getKey(first))) == null ? null : this.tableData.getRow(pos));
        return new HashCursor(result);
    }

    public int getCost(int[] masks) {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) continue;
            return Integer.MAX_VALUE;
        }
        return 2;
    }

    public void checkRename() throws SQLException {
    }

    public boolean needRebuild() {
        return true;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return false;
    }

    public Value findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }
}

