/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.unit;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import junit.textui.TestRunner;
import org.seasar.dao.unit.Department;
import org.seasar.dao.unit.Employee;
import org.seasar.dao.unit.S2DaoBeanReader;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.states.RowStates;

public class S2DaoBeanReaderTest
extends S2DaoTestCase {
    public S2DaoBeanReaderTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)S2DaoBeanReaderTest.class);
    }

    protected void setUp() throws Exception {
        this.include("j2ee.dicon");
    }

    public void testRead() throws Exception {
        Employee emp = new Employee();
        emp.setEmpno(7788L);
        emp.setEname("SCOTT");
        emp.setDeptno(10);
        Department dept = new Department();
        dept.setDeptno(10);
        dept.setDname("HOGE");
        emp.setDepartment(dept);
        S2DaoBeanReader reader = new S2DaoBeanReader((Object)emp, this.createBeanMetaData(emp.getClass()));
        DataSet ds = reader.read();
        DataTable table = ds.getTable(0);
        DataRow row = table.getRow(0);
        S2DaoBeanReaderTest.assertEquals((String)"1", (Object)new BigDecimal(7788.0), (Object)row.getValue("empno"));
        S2DaoBeanReaderTest.assertEquals((String)"2", (Object)"SCOTT", (Object)row.getValue("ename"));
        S2DaoBeanReaderTest.assertEquals((String)"3", (Object)new BigDecimal(10.0), (Object)row.getValue("deptno"));
        S2DaoBeanReaderTest.assertEquals((String)"4", (Object)"HOGE", (Object)row.getValue("dname_0"));
        S2DaoBeanReaderTest.assertEquals((String)"5", (Object)RowStates.UNCHANGED, (Object)row.getState());
    }

    public void testRead2() throws Exception {
        Employee emp = new Employee();
        emp.setEmpno(7788L);
        emp.setEname("SCOTT");
        Timestamp ts = new Timestamp(new Date().getTime());
        emp.setTimestamp(ts);
        S2DaoBeanReader reader = new S2DaoBeanReader((Object)emp, this.createBeanMetaData(emp.getClass()));
        DataSet ds = reader.read();
        DataTable table = ds.getTable(0);
        DataRow row = table.getRow(0);
        S2DaoBeanReaderTest.assertEquals((String)"1", (Object)new BigDecimal(7788.0), (Object)row.getValue("empno"));
        S2DaoBeanReaderTest.assertEquals((String)"2", (Object)"SCOTT", (Object)row.getValue("ename"));
        S2DaoBeanReaderTest.assertEquals((String)"3", (Object)ts, (Object)row.getValue("last_update"));
    }
}

