/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.unit;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.seasar.dao.unit.Department;
import org.seasar.dao.unit.Employee;
import org.seasar.dao.unit.S2DaoBeanListReader;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;

public class S2DaoBeanListReaderTest
extends S2DaoTestCase {
    protected void setUp() throws Exception {
        this.include("j2ee.dicon");
    }

    public void testRead() throws Exception {
        Employee emp = new Employee();
        emp.setEmpno(7788L);
        emp.setEname("SCOTT");
        emp.setDeptno(10);
        Department dept = new Department();
        dept.setDeptno(10);
        dept.setDname("HOGE");
        emp.setDepartment(dept);
        ArrayList<Employee> list = new ArrayList<Employee>();
        list.add(emp);
        S2DaoBeanListReader reader = new S2DaoBeanListReader(list, this.getBeanMetaDataFactory());
        DataSet ds = reader.read();
        DataTable table = ds.getTable(0);
        DataRow row = table.getRow(0);
        S2DaoBeanListReaderTest.assertEquals((String)"1", (Object)new BigDecimal(7788.0), (Object)row.getValue("empno"));
        S2DaoBeanListReaderTest.assertEquals((String)"2", (Object)"SCOTT", (Object)row.getValue("ename"));
        S2DaoBeanListReaderTest.assertEquals((String)"3", (Object)new BigDecimal(10.0), (Object)row.getValue("deptno"));
        S2DaoBeanListReaderTest.assertEquals((String)"4", (Object)"HOGE", (Object)row.getValue("dname_0"));
    }
}

