/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.parser;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.seasar.dao.TokenNotClosedRuntimeException;
import org.seasar.dao.parser.SqlTokenizerImpl;

public class SqlTokenizerImplTest
extends TestCase {
    public SqlTokenizerImplTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)SqlTokenizerImplTest.class);
    }

    public void testNext() throws Exception {
        String sql = "SELECT * FROM emp";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)sql, (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)99, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", null, (String)tokenizer.getToken());
    }

    public void testCommentEndNotFound() throws Exception {
        String sql = "SELECT * FROM emp/*hoge";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"SELECT * FROM emp", (String)tokenizer.getToken());
        try {
            tokenizer.next();
            SqlTokenizerImplTest.fail((String)"3");
        }
        catch (TokenNotClosedRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testBindVariable() throws Exception {
        String sql = "SELECT * FROM emp WHERE job = /*job*/'CLER K' AND deptno = /*deptno*/20";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"SELECT * FROM emp WHERE job = ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (String)"job", (String)tokenizer.getToken());
        tokenizer.skipToken();
        SqlTokenizerImplTest.assertEquals((String)"5", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"6", (String)" AND deptno = ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"7", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"8", (String)"deptno", (String)tokenizer.getToken());
        tokenizer.skipToken();
        SqlTokenizerImplTest.assertEquals((String)"9", (int)99, (int)tokenizer.next());
    }

    public void testParseBindVariable2() throws Exception {
        String sql = "SELECT * FROM emp WHERE job = /*job*/'CLERK'/**/";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"SELECT * FROM emp WHERE job = ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (String)"job", (String)tokenizer.getToken());
        tokenizer.skipToken();
        SqlTokenizerImplTest.assertEquals((String)"5", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"6", (String)"", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"7", (int)99, (int)tokenizer.next());
    }

    public void testParseBindVariable3() throws Exception {
        String sql = "/*job*/'CLERK',";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"job", (String)tokenizer.getToken());
        tokenizer.skipToken();
        SqlTokenizerImplTest.assertEquals((String)"3", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (String)",", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"5", (int)99, (int)tokenizer.next());
    }

    public void testParseElse() throws Exception {
        String sql = "SELECT * FROM emp WHERE /*IF job != null*/job = /*job*/'CLERK'-- ELSE job is null/*END*/";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"SELECT * FROM emp WHERE ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (String)"IF job != null", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"5", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"6", (String)"job = ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"7", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"8", (String)"job", (String)tokenizer.getToken());
        tokenizer.skipToken();
        SqlTokenizerImplTest.assertEquals((String)"9", (int)3, (int)tokenizer.next());
        tokenizer.skipWhitespace();
        SqlTokenizerImplTest.assertEquals((String)"10", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"11", (String)"job is null", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"12", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"13", (String)"END", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"14", (int)99, (int)tokenizer.next());
    }

    public void testParseElse2() throws Exception {
        String sql = "/*IF false*/aaa -- ELSE bbb = /*bbb*/123/*END*/";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"IF false", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (String)"aaa ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"5", (int)3, (int)tokenizer.next());
        tokenizer.skipWhitespace();
        SqlTokenizerImplTest.assertEquals((String)"6", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"7", (String)"bbb = ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"8", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"9", (String)"bbb", (String)tokenizer.getToken());
        tokenizer.skipToken();
        SqlTokenizerImplTest.assertEquals((String)"10", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"11", (String)"END", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"12", (int)99, (int)tokenizer.next());
    }

    public void testAnd() throws Exception {
        String sql = " AND bbb";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (String)" ", (String)tokenizer.skipWhitespace());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"AND", (String)tokenizer.skipToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (String)" AND", (String)tokenizer.getBefore());
        SqlTokenizerImplTest.assertEquals((String)"3", (String)" bbb", (String)tokenizer.getAfter());
    }

    public void testBindVariable2() throws Exception {
        String sql = "? abc ? def ?";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)4, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"$1", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (String)" abc ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"5", (int)4, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"6", (String)"$2", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"7", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"8", (String)" def ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"9", (int)4, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"10", (String)"$3", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"11", (int)99, (int)tokenizer.next());
    }

    public void testBindVariable3() throws Exception {
        String sql = "abc ? def";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"abc ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)4, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"5", (String)" def", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"6", (int)99, (int)tokenizer.next());
    }

    public void testBindVariable4() throws Exception {
        String sql = "/*IF false*/aaa--ELSE bbb = /*bbb*/123/*END*/";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (String)"IF false", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"3", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"4", (String)"aaa", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"5", (int)3, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"6", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"7", (String)" bbb = ", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"8", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"9", (String)"bbb", (String)tokenizer.getToken());
    }

    public void testSkipTokenForParent() throws Exception {
        String sql = "INSERT INTO TABLE_NAME (ID) VALUES (/*id*/20)";
        SqlTokenizerImpl tokenizer = new SqlTokenizerImpl(sql);
        SqlTokenizerImplTest.assertEquals((String)"1", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"2", (int)2, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"3", (String)"20", (String)tokenizer.skipToken());
        SqlTokenizerImplTest.assertEquals((String)"4", (int)1, (int)tokenizer.next());
        SqlTokenizerImplTest.assertEquals((String)"5", (String)")", (String)tokenizer.getToken());
        SqlTokenizerImplTest.assertEquals((String)"6", (int)99, (int)tokenizer.next());
    }
}

