/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import junit.framework.TestCase;
import org.seasar.dao.pager.MockResultSetFactory;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.pager.PagerResultSetFactoryLimitOffsetWrapper;
import org.seasar.extension.jdbc.ResultSetFactory;

public class PagerResultSetFactoryLimitOffsetWrapperTest
extends TestCase {
    MockResultSetFactory original;
    PagerResultSetFactoryLimitOffsetWrapper wrapper;

    protected void setUp() throws Exception {
        super.setUp();
        this.original = new MockResultSetFactory();
        this.wrapper = new PagerResultSetFactoryLimitOffsetWrapper((ResultSetFactory)this.original, "MySQL");
        PagerContext.start();
        PagerContext.getContext().pushArgs(this.createNormalArgs());
    }

    protected void tearDown() throws Exception {
        PagerContext.getContext().popArgs();
        PagerContext.end();
        super.tearDown();
    }

    public void testLimitOffsetSql() throws Exception {
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"\u6307\u5b9a\u3055\u308c\u305flimit offset\u304c\u4ed8\u52a0\u3055\u308c\u305fSQL\u3092\u751f\u6210", (String)"SELECT * FROM DEPARTMENT LIMIT 10 OFFSET 55", (String)this.wrapper.makeLimitOffsetSql("SELECT * FROM DEPARTMENT", 10, 55));
    }

    public void testMakeCountSql() throws Exception {
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(ORDER BY \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT ORDER BY id"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(whitespace\u4ed8\u304dorder by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT\n) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT\norder by\n    id"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE name like '%order by%' ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT WHERE name like '%order by%' order by id"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE name='aaa'/*order by*/) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT WHERE name='aaa'/*order by*/order by id"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE\n--order by\nname=1\n) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT WHERE\n--order by\nname=1\norder by id"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb UNICODE)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT order by \uff2e\uff2f"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb UNICODE)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT order by \u540d\u524d, \u7d44\u7e54_ID"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb ASC,DESC)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT order by \u540d\u524d ASC\n, \u7d44\u7e54_ID DESC"));
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb ASC,DESC+\u7a7a\u884c)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT order\n\tby\n\n \u540d\u524d \n\tASC \n\n\n, \u7d44\u7e54_ID \n\tDESC \n"));
    }

    public void testSetChopOrderByAndMakeCountSql() throws Exception {
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(chopOrderBy=true, order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT ) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
        this.wrapper.setChopOrderBy(false);
        PagerResultSetFactoryLimitOffsetWrapperTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(chopOrderBy=false, order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT order by id) AS total", (String)this.wrapper.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
    }

    private Object[] createNormalArgs() {
        return new Object[0];
    }
}

