/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.interceptors;

import java.util.List;
import java.util.Map;
import org.seasar.dao.interceptors.Employee;
import org.seasar.dao.interceptors.EmployeeDao;
import org.seasar.dao.interceptors.EmployeeDto;
import org.seasar.extension.unit.S2TestCase;

public class S2DaoInterceptorTest
extends S2TestCase {
    private EmployeeDao dao;

    public void setUp() {
        this.include("EmployeeDao.dicon");
    }

    public void testSelectBeanList() throws Exception {
        List employees = this.dao.getAllEmployees();
        for (int i = 0; i < employees.size(); ++i) {
            System.out.println(employees.get(i));
        }
        S2DaoInterceptorTest.assertEquals((String)"1", (boolean)true, (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testSelectBean() throws Exception {
        Employee employee = this.dao.getEmployee(7788);
        System.out.println(employee);
        S2DaoInterceptorTest.assertEquals((String)"1", (String)"SCOTT", (String)employee.getEname());
    }

    public void testSelectDto() throws Exception {
        EmployeeDto dto = this.dao.findEmployeeDto(7788);
        S2DaoInterceptorTest.assertEquals((String)"SCOTT", (String)dto.getEname());
        S2DaoInterceptorTest.assertEquals((String)"RESEARCH", (String)dto.getDname());
    }

    public void testSelectMap() throws Exception {
        Map[] ret = this.dao.getLabelValue();
        S2DaoInterceptorTest.assertTrue((ret.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < ret.length; ++i) {
            System.out.println(ret[i]);
        }
    }

    public void testSelectObject() throws Exception {
        int count = this.dao.getCount();
        System.out.println("count:" + count);
        S2DaoInterceptorTest.assertEquals((String)"1", (boolean)true, (count > 0 ? 1 : 0) != 0);
    }

    public void testUpdateTx() throws Exception {
        Employee employee = this.dao.getEmployee(7788);
        S2DaoInterceptorTest.assertEquals((String)"1", (int)1, (int)this.dao.update(employee));
    }

    public void testEntityManager() throws Exception {
        Employee[] employees = this.dao.getEmployeesByDeptno(10);
        S2DaoInterceptorTest.assertEquals((String)"1", (int)3, (int)employees.length);
    }

    public void testInsertTx() throws Exception {
        this.dao.insert(9999, "hoge");
    }
}

