/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.seasar.dao.NotFoundModifiedPropertiesRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.UpdateModifiedOnlyCommand;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.util.ClassUtil;

public class UpdateModifiedOnlyCommandTest
extends S2DaoTestCase {
    private EmpDao empDao;
    private Emp2Dao emp2Dao;
    private EmpByReflectionDao empByReflectionDao;
    static /* synthetic */ Class class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp;
    static /* synthetic */ Class class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp2;
    static /* synthetic */ Class class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp3;
    static /* synthetic */ Class class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Dept;
    static /* synthetic */ Class class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$EmpByReflection;

    protected void setUp() throws Exception {
        super.setUp();
        this.include(ClassUtil.getSimpleClassName((Class)UpdateModifiedOnlyCommandTest.class).replace('.', '/') + ".dicon");
    }

    public void testCreateModifiedPropertiesTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmpDao.class);
        SqlCommand findById = dmd.getSqlCommand("findById");
        Emp emp = (Emp)findById.execute(new Object[]{new Long(7499L)});
        System.out.println(emp);
        UpdateModifiedOnlyCommandTest.assertEquals((long)7499L, (long)emp.getEmpno());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)this.getBeanEnhancer().isEnhancedClass(emp.getClass()));
        emp.setEname("hoge");
        emp.setJob("hoge2");
        UpdateModifiedOnlyCommand updateModifiedOnly = (UpdateModifiedOnlyCommand)dmd.getSqlCommand("updateModifiedOnly");
        PropertyType[] propertyTypes = updateModifiedOnly.createUpdatePropertyTypes(dmd.getBeanMetaData(), (Object)emp, updateModifiedOnly.getPropertyNames());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType type = propertyTypes[i];
            set.add(type.getPropertyName());
            System.out.println(type.getPropertyName() + ", " + type.getColumnName());
        }
        UpdateModifiedOnlyCommandTest.assertEquals((int)3, (int)set.size());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("ename"));
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("job"));
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("timestamp"));
        Object result = updateModifiedOnly.execute(new Object[]{emp});
        Integer count = (Integer)result;
        UpdateModifiedOnlyCommandTest.assertEquals((int)1, (int)count);
    }

    public void testCreateModifiedPropertiesForChangedTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmpDao.class);
        SqlCommand findById = dmd.getSqlCommand("findById");
        Emp emp = (Emp)findById.execute(new Object[]{new Long(7499L)});
        System.out.println(emp);
        UpdateModifiedOnlyCommandTest.assertEquals((String)"ALLEN", (String)emp.getEname());
        emp.setEname("ALLEN");
        emp.setJob("hoge2");
        UpdateModifiedOnlyCommand updateModifiedOnly = (UpdateModifiedOnlyCommand)dmd.getSqlCommand("updateModifiedOnly");
        PropertyType[] propertyTypes = updateModifiedOnly.createUpdatePropertyTypes(dmd.getBeanMetaData(), (Object)emp, updateModifiedOnly.getPropertyNames());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType type = propertyTypes[i];
            set.add(type.getPropertyName());
            System.out.println(type.getPropertyName() + ", " + type.getColumnName());
        }
        UpdateModifiedOnlyCommandTest.assertEquals((int)2, (int)set.size());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("job"));
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("timestamp"));
        Object result = updateModifiedOnly.execute(new Object[]{emp});
        Integer count = (Integer)result;
        UpdateModifiedOnlyCommandTest.assertEquals((int)1, (int)count);
    }

    public void testCreateModifiedPropertiesNoChangedTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmpDao.class);
        SqlCommand findById = dmd.getSqlCommand("findById");
        Emp emp = (Emp)findById.execute(new Object[]{new Long(7499L)});
        System.out.println(emp);
        UpdateModifiedOnlyCommand updateModifiedOnly = (UpdateModifiedOnlyCommand)dmd.getSqlCommand("updateModifiedOnly");
        PropertyType[] propertyTypes = updateModifiedOnly.createUpdatePropertyTypes(dmd.getBeanMetaData(), (Object)emp, updateModifiedOnly.getPropertyNames());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType type = propertyTypes[i];
            set.add(type.getPropertyName());
            System.out.println(type.getPropertyName() + ", " + type.getColumnName());
        }
        UpdateModifiedOnlyCommandTest.assertEquals((int)1, (int)set.size());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("timestamp"));
        Object result = updateModifiedOnly.execute(new Object[]{emp});
        Integer count = (Integer)result;
        UpdateModifiedOnlyCommandTest.assertEquals((int)1, (int)count);
    }

    public void testNoUpdateTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Emp3Dao.class);
        SqlCommand findById = dmd.getSqlCommand("findById");
        Emp3 emp = (Emp3)findById.execute(new Object[]{new Long(7499L)});
        System.out.println(emp);
        UpdateModifiedOnlyCommand updateModifiedOnly = (UpdateModifiedOnlyCommand)dmd.getSqlCommand("updateModifiedOnly");
        PropertyType[] propertyTypes = updateModifiedOnly.createUpdatePropertyTypes(dmd.getBeanMetaData(), (Object)emp, updateModifiedOnly.getPropertyNames());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType type = propertyTypes[i];
            set.add(type.getPropertyName());
            System.out.println(type.getPropertyName() + ", " + type.getColumnName());
        }
        UpdateModifiedOnlyCommandTest.assertEquals((int)0, (int)set.size());
        Object result = updateModifiedOnly.execute(new Object[]{emp});
        Integer count = (Integer)result;
        UpdateModifiedOnlyCommandTest.assertEquals((int)0, (int)count);
    }

    public void testRelationCreateModifiedPropertiesTx() throws Exception {
        Emp2 emp = this.emp2Dao.findById(7499L);
        System.out.println(emp);
        UpdateModifiedOnlyCommandTest.assertEquals((long)7499L, (long)emp.getEmpno());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)this.getBeanEnhancer().isEnhancedClass(emp.getClass()));
        Dept dept = emp.getDept();
        UpdateModifiedOnlyCommandTest.assertNotNull((Object)dept);
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)this.getBeanEnhancer().isEnhancedClass(dept.getClass()));
        System.out.println(dept);
        System.out.println(dept.getClass());
        dept.setDname("FOO");
        DaoMetaDataImpl dmd = this.createDaoMetaData(DeptDao.class);
        UpdateModifiedOnlyCommand updateModifiedOnly = (UpdateModifiedOnlyCommand)dmd.getSqlCommand("updateModifiedOnly");
        PropertyType[] propertyTypes = updateModifiedOnly.createUpdatePropertyTypes(dmd.getBeanMetaData(), (Object)dept, updateModifiedOnly.getPropertyNames());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType type = propertyTypes[i];
            set.add(type.getPropertyName());
            System.out.println(type.getPropertyName() + ", " + type.getColumnName());
        }
        UpdateModifiedOnlyCommandTest.assertEquals((int)1, (int)set.size());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("dname"));
        updateModifiedOnly.execute(new Object[]{dept});
        Emp2 emp2 = this.emp2Dao.findById(7499L);
        UpdateModifiedOnlyCommandTest.assertEquals((String)"FOO", (String)emp2.getDept().getDname());
    }

    public void testListRelationCreateModifiedPropertiesTx() throws Exception {
        List emps = this.emp2Dao.findByJob("MANAGER");
        System.out.println(emps);
        Emp2 emp1 = (Emp2)emps.get(0);
        UpdateModifiedOnlyCommandTest.assertEquals((long)7566L, (long)emp1.getEmpno());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)this.getBeanEnhancer().isEnhancedClass(emp1.getClass()));
        Dept dept = emp1.getDept();
        UpdateModifiedOnlyCommandTest.assertNotNull((Object)dept);
        UpdateModifiedOnlyCommandTest.assertEquals((String)"RESEARCH", (String)dept.getDname());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)this.getBeanEnhancer().isEnhancedClass(dept.getClass()));
        dept.setDname("baar");
        DaoMetaDataImpl dmd = this.createDaoMetaData(DeptDao.class);
        UpdateModifiedOnlyCommand updateModifiedOnly = (UpdateModifiedOnlyCommand)dmd.getSqlCommand("updateModifiedOnly");
        PropertyType[] propertyTypes = updateModifiedOnly.createUpdatePropertyTypes(dmd.getBeanMetaData(), (Object)dept, updateModifiedOnly.getPropertyNames());
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType type = propertyTypes[i];
            set.add(type.getPropertyName());
            System.out.println(type.getPropertyName() + ", " + type.getColumnName());
        }
        UpdateModifiedOnlyCommandTest.assertEquals((int)1, (int)set.size());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)true, (boolean)set.contains("dname"));
        updateModifiedOnly.execute(new Object[]{dept});
        Emp2 emp2 = this.emp2Dao.findById(7566L);
        UpdateModifiedOnlyCommandTest.assertEquals((String)"baar", (String)emp2.getDept().getDname());
    }

    public void testUpdateModifiedOnlyWithNotSupportBeanTx() throws Exception {
        int targetEmpno = 7499;
        Emp emp = new Emp();
        emp.setEmpno(7499L);
        emp.setEname("UpdateModifiedOnlyWithNotSupportBean");
        try {
            this.empDao.updateModifiedOnly(emp);
            UpdateModifiedOnlyCommandTest.fail((String)("If the bean doesn't have modified properties, this invoking should throw exception: " + emp));
        }
        catch (NotFoundModifiedPropertiesRuntimeException e) {
            UpdateModifiedOnlyCommandTest.assertEquals((String)emp.getClass().getName(), (String)e.getBeanClassName());
            System.out.println(e.getMessage());
        }
    }

    public void testModifiedPropertiesByReflectionTx() throws Exception {
        int targetEmpno = 7499;
        EmpByReflection expectedEmp = this.empByReflectionDao.findById(7499L);
        EmpByReflection emp = new EmpByReflection();
        emp.setEmpno(7499L);
        emp.setEname("ModifiedPropertiesByReflection");
        int updatedCount = this.empByReflectionDao.updateModifiedOnly(emp);
        UpdateModifiedOnlyCommandTest.assertEquals((int)1, (int)updatedCount);
        EmpByReflection actualEmp = this.empByReflectionDao.findById(7499L);
        UpdateModifiedOnlyCommandTest.assertEquals((long)expectedEmp.getEmpno(), (long)actualEmp.getEmpno());
        UpdateModifiedOnlyCommandTest.assertEquals((String)"ModifiedPropertiesByReflection", (String)actualEmp.getEname());
        UpdateModifiedOnlyCommandTest.assertEquals((String)expectedEmp.getJob(), (String)actualEmp.getJob());
        UpdateModifiedOnlyCommandTest.assertEquals((Object)expectedEmp.getComm(), (Object)actualEmp.getComm());
        UpdateModifiedOnlyCommandTest.assertEquals((Object)expectedEmp.getSal(), (Object)actualEmp.getSal());
        UpdateModifiedOnlyCommandTest.assertEquals((boolean)false, (boolean)this.getBeanEnhancer().isEnhancedClass(actualEmp.getClass()));
    }

    public static class EmpByReflection {
        public static final String TABLE = "EMP";
        private long empno;
        private String ename;
        private String job;
        private Float sal;
        private Float comm;
        private Set _modifiedPropertySet = new HashSet();

        public long getEmpno() {
            return this.empno;
        }

        public void setEmpno(long empno) {
            this._modifiedPropertySet.add("empno");
            this.empno = empno;
        }

        public String getEname() {
            return this.ename;
        }

        public void setEname(String ename) {
            this._modifiedPropertySet.add("ename");
            this.ename = ename;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this._modifiedPropertySet.add("job");
            this.job = job;
        }

        public Float getSal() {
            return this.sal;
        }

        public void setSal(Float sal) {
            this._modifiedPropertySet.add("sal");
            this.sal = sal;
        }

        public Float getComm() {
            return this.comm;
        }

        public void setComm(Float comm) {
            this._modifiedPropertySet.add("comm");
            this.comm = comm;
        }

        public Set getModifiedPropertyNames() {
            return this._modifiedPropertySet;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.empno).append(", ");
            buf.append(this.ename).append(", ");
            buf.append(this.job).append(", ");
            buf.append(this.sal).append(", ");
            buf.append(this.comm).append(", ");
            return buf.toString();
        }
    }

    public static interface EmpByReflectionDao {
        public static final Class BEAN = class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$EmpByReflection == null ? (class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$EmpByReflection = UpdateModifiedOnlyCommandTest.class$("org.seasar.dao.impl.UpdateModifiedOnlyCommandTest$EmpByReflection")) : class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$EmpByReflection;
        public static final String findById_ARGS = "empno";

        public EmpByReflection findById(long var1);

        public int updateModifiedOnly(EmpByReflection var1);
    }

    public static class Dept {
        public static final String TABLE = "DEPT";
        private long deptno;
        private String dname;
        private String loc;

        public long getDeptno() {
            return this.deptno;
        }

        public void setDeptno(long deptno) {
            this.deptno = deptno;
        }

        public String getDname() {
            return this.dname;
        }

        public void setDname(String dname) {
            this.dname = dname;
        }

        public String getLoc() {
            return this.loc;
        }

        public void setLoc(String loc) {
            this.loc = loc;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.deptno).append(", ");
            buf.append(this.dname).append(", ");
            buf.append(this.loc);
            return buf.toString();
        }
    }

    public static class Emp3 {
        public static final String TABLE = "EMP";
        private long empno;
        private String ename;
        private String job;
        private Float sal;
        private Float comm;

        public long getEmpno() {
            return this.empno;
        }

        public void setEmpno(long empno) {
            this.empno = empno;
        }

        public String getEname() {
            return this.ename;
        }

        public void setEname(String ename) {
            this.ename = ename;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this.job = job;
        }

        public Float getSal() {
            return this.sal;
        }

        public void setSal(Float sal) {
            this.sal = sal;
        }

        public Float getComm() {
            return this.comm;
        }

        public void setComm(Float comm) {
            this.comm = comm;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.empno).append(", ");
            buf.append(this.ename).append(", ");
            buf.append(this.job).append(", ");
            buf.append(this.sal).append(", ");
            buf.append(this.comm);
            return buf.toString();
        }
    }

    public static class Emp2 {
        public static final String TABLE = "EMP";
        public static final int dept_RELNO = 0;
        public static final String timestamp_COLUMN = "tstamp";
        private long empno;
        private String ename;
        private String job;
        private Float sal;
        private Float comm;
        private Timestamp timestamp;
        private Dept dept;

        public long getEmpno() {
            return this.empno;
        }

        public void setEmpno(long empno) {
            this.empno = empno;
        }

        public String getEname() {
            return this.ename;
        }

        public void setEname(String ename) {
            this.ename = ename;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this.job = job;
        }

        public Float getSal() {
            return this.sal;
        }

        public void setSal(Float sal) {
            this.sal = sal;
        }

        public Float getComm() {
            return this.comm;
        }

        public void setComm(Float comm) {
            this.comm = comm;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public Dept getDept() {
            return this.dept;
        }

        public void setDept(Dept dept) {
            this.dept = dept;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.empno).append(", ");
            buf.append(this.ename).append(", ");
            buf.append(this.job).append(", ");
            buf.append(this.sal).append(", ");
            buf.append(this.comm).append(", ");
            buf.append(this.timestamp);
            return buf.toString();
        }
    }

    public static class Emp {
        public static final String TABLE = "EMP";
        public static final String timestamp_COLUMN = "tstamp";
        private long empno;
        private String ename;
        private String job;
        private Float sal;
        private Float comm;
        private Timestamp timestamp;

        public long getEmpno() {
            return this.empno;
        }

        public void setEmpno(long empno) {
            this.empno = empno;
        }

        public String getEname() {
            return this.ename;
        }

        public void setEname(String ename) {
            this.ename = ename;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this.job = job;
        }

        public Float getSal() {
            return this.sal;
        }

        public void setSal(Float sal) {
            this.sal = sal;
        }

        public Float getComm() {
            return this.comm;
        }

        public void setComm(Float comm) {
            this.comm = comm;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.empno).append(", ");
            buf.append(this.ename).append(", ");
            buf.append(this.job).append(", ");
            buf.append(this.sal).append(", ");
            buf.append(this.comm).append(", ");
            buf.append(this.timestamp);
            return buf.toString();
        }
    }

    public static interface DeptDao {
        public static final Class BEAN = class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Dept == null ? (class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Dept = UpdateModifiedOnlyCommandTest.class$("org.seasar.dao.impl.UpdateModifiedOnlyCommandTest$Dept")) : class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Dept;
        public static final String findById_ARGS = "deptno";

        public Dept findById(long var1);

        public int updateModifiedOnly(Dept var1);
    }

    public static interface Emp3Dao {
        public static final Class BEAN = class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp3 == null ? (class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp3 = UpdateModifiedOnlyCommandTest.class$("org.seasar.dao.impl.UpdateModifiedOnlyCommandTest$Emp3")) : class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp3;
        public static final String findById_ARGS = "empno";
        public static final String findByJob_ARGS = "job";

        public Emp3 findById(long var1);

        public List findByJob(String var1);

        public int updateModifiedOnly(Emp3 var1);
    }

    public static interface Emp2Dao {
        public static final Class BEAN = class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp2 == null ? (class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp2 = UpdateModifiedOnlyCommandTest.class$("org.seasar.dao.impl.UpdateModifiedOnlyCommandTest$Emp2")) : class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp2;
        public static final String findById_ARGS = "empno";
        public static final String findByJob_ARGS = "job";

        public Emp2 findById(long var1);

        public List findByJob(String var1);

        public int updateModifiedOnly(Emp2 var1);
    }

    public static interface EmpDao {
        public static final Class BEAN = class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp == null ? (class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp = UpdateModifiedOnlyCommandTest.class$("org.seasar.dao.impl.UpdateModifiedOnlyCommandTest$Emp")) : class$org$seasar$dao$impl$UpdateModifiedOnlyCommandTest$Emp;
        public static final String findById_ARGS = "empno";

        public Emp findById(long var1);

        public int updateModifiedOnly(Emp var1);
    }
}

