/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.Procedures;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.jdbc.impl.MapListResultSetHandler;
import org.seasar.framework.exception.SIllegalArgumentException;

public class StaticStoredProcedureCommandTest
extends S2DaoTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.include("dao-derby.dicon");
        Procedures.params = new HashMap();
    }

    protected void tearDown() throws Exception {
        Procedures.params = null;
        super.tearDown();
    }

    public void testOutParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("aaa1");
        String aaa = (String)command.execute(new Object[0]);
        StaticStoredProcedureCommandTest.assertEquals((String)"aaaaa", (String)aaa);
    }

    public void testMultiOutParametersTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("aaa2");
        long t1 = System.currentTimeMillis();
        Map aaa = (Map)command.execute(new Object[0]);
        long t2 = System.currentTimeMillis();
        System.out.println(aaa);
        StaticStoredProcedureCommandTest.assertEquals((Object)"aaaaa2", aaa.get("BBB"));
        Timestamp timestamp = (Timestamp)aaa.get("CCC");
        StaticStoredProcedureCommandTest.assertEquals((boolean)true, (t1 <= timestamp.getTime() ? 1 : 0) != 0);
        StaticStoredProcedureCommandTest.assertEquals((boolean)true, (timestamp.getTime() <= t2 ? 1 : 0) != 0);
    }

    public void testNoParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("aaa3");
        command.execute(new Object[0]);
        StaticStoredProcedureCommandTest.assertTrue((boolean)Procedures.isAaa3Invoked);
    }

    public void testInParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("bbb1");
        command.execute(new Object[]{"abcde"});
        StaticStoredProcedureCommandTest.assertEquals((Object)"abcde", Procedures.params.get("ccc"));
    }

    public void testMultiInParametersTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("bbb2");
        long current = System.currentTimeMillis();
        command.execute(new Object[]{"abcde", new Integer(111), new Timestamp(current)});
        StaticStoredProcedureCommandTest.assertEquals((Object)"abcde", Procedures.params.get("ccc"));
        StaticStoredProcedureCommandTest.assertEquals((int)111, (int)((BigDecimal)Procedures.params.get("ddd")).intValue());
        StaticStoredProcedureCommandTest.assertEquals((long)current, (long)((Timestamp)Procedures.params.get("eee")).getTime());
    }

    public void testInOutMixedParameters1Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("ccc1");
        String ret = (String)command.execute(new Object[]{"foo", new Integer(112)});
        StaticStoredProcedureCommandTest.assertEquals((String)"foo112", (String)ret);
        StaticStoredProcedureCommandTest.assertEquals((Object)"foo", Procedures.params.get("ccc"));
        StaticStoredProcedureCommandTest.assertEquals((int)112, (int)((BigDecimal)Procedures.params.get("ddd")).intValue());
        String[] eee = (String[])Procedures.params.get("eee");
        StaticStoredProcedureCommandTest.assertEquals((int)1, (int)eee.length);
    }

    public void testInOutMixedParameters2Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("ccc2");
        Map ret = (Map)command.execute(new Object[]{new Integer(25)});
        System.out.println(ret);
        StaticStoredProcedureCommandTest.assertEquals((Object)"25", ret.get("CCC"));
        StaticStoredProcedureCommandTest.assertEquals((Object)"625", ret.get("EEE"));
        String[] ccc = (String[])Procedures.params.get("ccc");
        StaticStoredProcedureCommandTest.assertEquals((int)1, (int)ccc.length);
        StaticStoredProcedureCommandTest.assertEquals((int)25, (int)((BigDecimal)Procedures.params.get("ddd")).intValue());
        String[] eee = (String[])Procedures.params.get("eee");
        StaticStoredProcedureCommandTest.assertEquals((int)1, (int)eee.length);
    }

    public void testInOutParameterTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("ddd1");
        String ret = (String)command.execute(new Object[]{"ab"});
        StaticStoredProcedureCommandTest.assertEquals((String)"abcd", (String)ret);
        String[] ccc = (String[])Procedures.params.get("ccc");
        StaticStoredProcedureCommandTest.assertEquals((int)1, (int)ccc.length);
    }

    public void testIllegalArgSize() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(ProcedureDao.class);
        SqlCommand command = dmd.getSqlCommand("illegalArgSizeBbb2");
        try {
            command.execute(new Object[]{"abcde", new Integer(111)});
        }
        catch (SIllegalArgumentException e) {
            System.out.println(e.getMessage());
            StaticStoredProcedureCommandTest.assertEquals((String)"EDAO0032", (String)e.getMessageCode());
        }
    }

    public void testMetaData() throws Exception {
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        System.out.println("DatabaseProductName=" + metaData.getDatabaseProductName());
        System.out.println("DatabaseProductVersion=" + metaData.getDatabaseProductVersion());
        System.out.println("DriverName=" + metaData.getDriverName());
        System.out.println("DriverVersion=" + metaData.getDriverVersion());
    }

    public void testMetaDataForProcesures() throws Exception {
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet rset = metaData.getProcedures(null, null, null);
        MapListResultSetHandler handler = new MapListResultSetHandler();
        List l = (List)handler.handle(rset);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            System.out.println(m);
        }
    }

    public void testMetaDataForTables() throws Exception {
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        ResultSet rset = metaData.getTables(null, null, null, null);
        MapListResultSetHandler handler = new MapListResultSetHandler();
        List l = (List)handler.handle(rset);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            System.out.println(m);
        }
    }

    public static interface ProcedureDao {
        public static final String aaa1_PROCEDURE = "PROCEDURE_TEST_AAA1";
        public static final String aaa2_PROCEDURE = "PROCEDURE_TEST_AAA2";
        public static final String aaa3_PROCEDURE = "PROCEDURE_TEST_AAA3";
        public static final String bbb1_PROCEDURE = "PROCEDURE_TEST_BBB1";
        public static final String bbb2_PROCEDURE = "PROCEDURE_TEST_BBB2";
        public static final String illegalArgSizeBbb2_PROCEDURE = "PROCEDURE_TEST_BBB2";
        public static final String ccc1_PROCEDURE = "PROCEDURE_TEST_CCC1";
        public static final String ccc2_PROCEDURE = "PROCEDURE_TEST_CCC2";
        public static final String ddd1_PROCEDURE = "PROCEDURE_TEST_DDD1";

        public String aaa1();

        public Map aaa2();

        public Map aaa3();

        public void bbb1(String var1);

        public void bbb2(String var1, Integer var2, Timestamp var3);

        public void illegalArgSizeBbb2(String var1, Integer var2);

        public String ccc1(String var1, Integer var2);

        public Map ccc2(Integer var1);

        public String ddd1(String var1);
    }
}

