/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.List;
import java.util.Map;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.EntityManager;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.EmployeeDao;
import org.seasar.dao.impl.EmployeeDto;
import org.seasar.dao.impl.EntityManagerImpl;
import org.seasar.dao.pager.PagerContext;
import org.seasar.extension.unit.S2TestCase;

public class EntityManagerImplTest
extends S2TestCase {
    private EntityManager entityManager;

    public void testFind() throws Exception {
        List employees = this.entityManager.find("empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (int)1, (int)employees.size());
    }

    public void testFind_BTS6491() throws Exception {
        List employees = this.entityManager.find("\n SELECT * FROM EMP WHERE empno = ?", (Object)new Integer(7788));
        System.out.println(employees);
        EntityManagerImplTest.assertEquals((String)"1", (int)1, (int)employees.size());
    }

    public void testFind_BTS6491_ByDto() throws Exception {
        List employees = this.entityManager.find(EmployeeDto.class, "\n SELECT * FROM EMP WHERE empno = ?", (Object)new Integer(7788));
        System.out.println(employees);
        EntityManagerImplTest.assertEquals((String)"1", (int)1, (int)employees.size());
        EntityManagerImplTest.assertTrue((String)"2", (boolean)(employees.get(0) instanceof EmployeeDto));
    }

    public void testFindArray() throws Exception {
        Employee[] employees = (Employee[])this.entityManager.findArray("empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (int)1, (int)employees.length);
    }

    public void testFindArrayByDto() throws Exception {
        EmployeeDto[] employees = (EmployeeDto[])this.entityManager.findArray(EmployeeDto.class, "empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (int)1, (int)employees.length);
    }

    public void testFindBean() throws Exception {
        Employee employee = (Employee)this.entityManager.findBean("empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (String)"SCOTT", (String)employee.getEname());
    }

    public void testFindBeanByDto() throws Exception {
        EmployeeDto employee = (EmployeeDto)this.entityManager.findBean(EmployeeDto.class, "empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (String)"SCOTT", (String)employee.getEname());
    }

    public void testFindMap() throws Exception {
        Map employee = this.entityManager.findMap("empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (Object)"SCOTT", employee.get("ename"));
    }

    public void testFindMapList() throws Exception {
        List employees = this.entityManager.findMapList("empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (int)1, (int)employees.size());
        EntityManagerImplTest.assertEquals((String)"2", (Object)"SCOTT", ((Map)employees.get(0)).get("ename"));
    }

    public void testFindMapArray() throws Exception {
        Map[] employees = this.entityManager.findMapArray("empno = ?", (Object)new Integer(7788));
        EntityManagerImplTest.assertEquals((String)"1", (int)1, (int)employees.length);
        EntityManagerImplTest.assertEquals((String)"2", (Object)"SCOTT", employees[0].get("ename"));
    }

    public void testFindObject() throws Exception {
        Integer count = (Integer)this.entityManager.findObject("select count(*) from emp");
        EntityManagerImplTest.assertEquals((String)"1", (Object)new Integer(14), (Object)count);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.include("dao.dicon");
        PagerContext.start();
        DaoMetaDataFactory factory = (DaoMetaDataFactory)this.getComponent(DaoMetaDataFactory.class);
        DaoMetaData daoMetaData = factory.getDaoMetaData(EmployeeDao.class);
        this.entityManager = new EntityManagerImpl(daoMetaData);
    }

    protected void tearDown() throws Exception {
        PagerContext.end();
        super.tearDown();
    }
}

