/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.extension.jdbc.impl.MapListResultSetHandler;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.exception.SRuntimeException;

public class DefaultTest
extends S2TestCase {
    private DefaultTableDao defaultTableDao;
    private PkOnlyTableDao pkOnlyTableDao;
    static /* synthetic */ Class class$org$seasar$dao$impl$DefaultTest$DefaultTable;
    static /* synthetic */ Class class$org$seasar$dao$impl$DefaultTest$PkOnlyTable;

    protected void setUp() throws Exception {
        super.setUp();
        this.include("DefaultTest.dicon");
    }

    public void testLearningMetaDataForColumnsTx() throws Exception {
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        String userName = metaData.getUserName();
        userName = DatabaseMetaDataUtil.convertIdentifier((DatabaseMetaData)metaData, (String)userName);
        ResultSet rset = metaData.getColumns(null, userName, "DEFAULT_TABLE", null);
        ResultSetMetaData rMeta = rset.getMetaData();
        int columnCount = rMeta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = rMeta.getColumnName(i);
            System.out.println("[" + i + "] " + columnName);
        }
        MapListResultSetHandler handler = new MapListResultSetHandler();
        List l = (List)handler.handle(rset);
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            System.out.println(m);
        }
    }

    public void testLearningGetDefaultValueTx() throws Exception {
        DatabaseMetaData metaData = this.getConnection().getMetaData();
        String userName = DatabaseMetaDataUtil.convertIdentifier((DatabaseMetaData)metaData, (String)metaData.getUserName());
        ResultSet rset = metaData.getColumns(null, userName, "DEFAULT_TABLE", null);
        int[] columns = new int[]{0, 0, 0, 0};
        while (rset.next()) {
            String columnName = rset.getString("COLUMN_NAME");
            String columnDef = rset.getString("COLUMN_DEF");
            System.out.println(columnName + "[" + columnDef + "]");
            if ("ID".equals(columnName)) {
                columns[0] = columns[0] + 1;
                continue;
            }
            if ("AAA".equals(columnName)) {
                columns[1] = columns[1] + 1;
                DefaultTest.assertEquals((String)columnDef, (boolean)true, (columnDef.indexOf("ABC") > -1 ? 1 : 0) != 0);
                continue;
            }
            if ("BBB".equals(columnName)) {
                columns[2] = columns[2] + 1;
                DefaultTest.assertEquals((String)columnDef, (String)null, (String)columnDef);
                continue;
            }
            if ("VERSION_NO".equals(columnName)) {
                columns[3] = columns[3] + 1;
                DefaultTest.assertEquals((String)columnDef, (String)null, (String)columnDef);
                continue;
            }
            DefaultTest.fail((String)columnName);
        }
        DefaultTest.assertEquals((int)1, (int)columns[0]);
        DefaultTest.assertEquals((int)1, (int)columns[1]);
        DefaultTest.assertEquals((int)1, (int)columns[2]);
        DefaultTest.assertEquals((int)1, (int)columns[3]);
    }

    public void testInsertByAutoSqlTx() throws Exception {
        DefaultTable bean = new DefaultTable();
        bean.setAaa("1234567");
        bean.setBbb("890");
        this.defaultTableDao.insert(bean);
        Integer id = bean.getId();
        bean = this.defaultTableDao.getDefaultTable(id);
        DefaultTest.assertEquals((String)"inserted setted value", (String)"1234567", (String)bean.getAaa());
        DefaultTest.assertEquals((String)"890", (String)bean.getBbb());
        DefaultTest.assertEquals((Object)new Integer(0), (Object)bean.getVersionNo());
    }

    public void testInsertBatchByAutoSqlTx() throws Exception {
        DefaultTable bean1 = new DefaultTable();
        bean1.setAaa("11");
        bean1.setBbb("12");
        DefaultTable bean2 = new DefaultTable();
        bean2.setAaa("21");
        bean2.setBbb("22");
        int ret = this.defaultTableDao.insertBatch(new DefaultTable[]{bean1, bean2});
        DefaultTest.assertEquals((int)2, (int)ret);
        List defaultTables = this.defaultTableDao.getDefaultTables();
        DefaultTest.assertEquals((int)2, (int)defaultTables.size());
        DefaultTable object = (DefaultTable)defaultTables.get(0);
        DefaultTest.assertEquals((String)"11", (String)object.getAaa());
        DefaultTest.assertEquals((String)"12", (String)object.getBbb());
        object = (DefaultTable)defaultTables.get(1);
        DefaultTest.assertEquals((String)"21", (String)object.getAaa());
        DefaultTest.assertEquals((String)"22", (String)object.getBbb());
    }

    public void testInsertBatchDefaultByAutoSqlTx() throws Exception {
        DefaultTable bean1 = new DefaultTable();
        bean1.setAaa("11");
        bean1.setBbb("12");
        DefaultTable bean2 = new DefaultTable();
        bean2.setAaa(null);
        bean2.setBbb("22");
        DefaultTable bean3 = new DefaultTable();
        bean3.setAaa("31");
        bean3.setBbb(null);
        int ret = this.defaultTableDao.insertBatch(new DefaultTable[]{bean1, bean2, bean3});
        DefaultTest.assertEquals((int)3, (int)ret);
        List defaultTables = this.defaultTableDao.getDefaultTables();
        DefaultTest.assertEquals((int)3, (int)defaultTables.size());
        DefaultTable object = (DefaultTable)defaultTables.get(0);
        DefaultTest.assertEquals((String)"11", (String)object.getAaa());
        DefaultTest.assertEquals((String)"12", (String)object.getBbb());
        object = (DefaultTable)defaultTables.get(1);
        DefaultTest.assertEquals((String)null, (String)object.getAaa());
        DefaultTest.assertEquals((String)"22", (String)object.getBbb());
        object = (DefaultTable)defaultTables.get(2);
        DefaultTest.assertEquals((String)"31", (String)object.getAaa());
        DefaultTest.assertEquals((String)null, (String)object.getBbb());
    }

    public void testInsertBatchDefaultByAutoSql2Tx() throws Exception {
        DefaultTable bean1 = new DefaultTable();
        bean1.setAaa("11");
        bean1.setBbb(null);
        DefaultTable bean2 = new DefaultTable();
        bean2.setAaa("21");
        bean2.setBbb("22");
        int ret = this.defaultTableDao.insertBatch(new DefaultTable[]{bean1, bean2});
        DefaultTest.assertEquals((int)2, (int)ret);
        List defaultTables = this.defaultTableDao.getDefaultTables();
        DefaultTest.assertEquals((int)2, (int)defaultTables.size());
        DefaultTable object = (DefaultTable)defaultTables.get(0);
        DefaultTest.assertEquals((String)"11", (String)object.getAaa());
        DefaultTest.assertEquals((String)null, (String)object.getBbb());
        object = (DefaultTable)defaultTables.get(1);
        DefaultTest.assertEquals((String)"21", (String)object.getAaa());
        DefaultTest.assertEquals((String)"22", (String)object.getBbb());
    }

    public void testInsertDefaultByAutoSqlTx() throws Exception {
        DefaultTable bean = new DefaultTable();
        bean.setBbb("bbbb");
        this.defaultTableDao.insert(bean);
        Integer id = bean.getId();
        bean = this.defaultTableDao.getDefaultTable(id);
        DefaultTest.assertEquals((String)"inserted DEFAULT value", (String)"ABC", (String)bean.getAaa());
        DefaultTest.assertEquals((String)"bbbb", (String)bean.getBbb());
        DefaultTest.assertEquals((Object)new Integer(0), (Object)bean.getVersionNo());
    }

    public void testNotThrownExceptionWhenNullDataOnlyTx() throws Exception {
        DefaultTable bean = new DefaultTable();
        this.defaultTableDao.insert(bean);
        Integer id = bean.getId();
        bean = this.defaultTableDao.getDefaultTable(id);
        DefaultTest.assertEquals((String)"inserted DEFAULT value", (String)"ABC", (String)bean.getAaa());
        DefaultTest.assertEquals((String)null, (String)bean.getBbb());
        DefaultTest.assertEquals((Object)new Integer(0), (Object)bean.getVersionNo());
    }

    public void no_testThrownExceptionWhenNullDataOnlyByBatchTx() throws Exception {
        DefaultTable bean = new DefaultTable();
        try {
            this.defaultTableDao.insertBatch(new DefaultTable[]{bean});
            DefaultTest.fail((String)"should be thrown SRuntimeException, when only null properties");
        }
        catch (SRuntimeException e) {
            e.printStackTrace();
            DefaultTest.assertEquals((String)"EDAO0014", (String)e.getMessageCode());
        }
    }

    public void testInsertByManualSqlTx() throws Exception {
        DefaultTable bean = new DefaultTable();
        bean.setAaa("foooo");
        this.defaultTableDao.insertBySql(bean);
        Integer id = bean.getId();
        bean = this.defaultTableDao.getDefaultTable(id);
        DefaultTest.assertEquals((String)"foooo", (String)bean.getAaa());
        DefaultTest.assertEquals((String)null, (String)bean.getBbb());
        DefaultTest.assertEquals((Object)new Integer(0), (Object)bean.getVersionNo());
    }

    public void testInsertDefaultByManualSqlTx() throws Exception {
        DefaultTable bean = new DefaultTable();
        bean.setBbb("ttt");
        this.defaultTableDao.insertBySql(bean);
        Integer id = bean.getId();
        bean = this.defaultTableDao.getDefaultTable(id);
        DefaultTest.assertEquals((String)"ABC", (String)bean.getAaa());
        DefaultTest.assertEquals((String)"ttt", (String)bean.getBbb());
        DefaultTest.assertEquals((Object)new Integer(0), (Object)bean.getVersionNo());
    }

    public void testInsertPkOnlyTableTx() throws Exception {
        PkOnlyTable bean = new PkOnlyTable();
        bean.setAaa(new Integer(123));
        bean.setBbb(new Integer(456));
        this.pkOnlyTableDao.insert(bean);
        List list = this.pkOnlyTableDao.findAll();
        DefaultTest.assertEquals((int)1, (int)list.size());
    }

    public static class PkOnlyTable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String TABLE = "PK_ONLY_TABLE";
        private Integer aaa;
        private Integer bbb;

        public Integer getAaa() {
            return this.aaa;
        }

        public void setAaa(Integer aaa) {
            this.aaa = aaa;
        }

        public Integer getBbb() {
            return this.bbb;
        }

        public void setBbb(Integer bbb) {
            this.bbb = bbb;
        }
    }

    public static interface PkOnlyTableDao {
        public static final Class BEAN = class$org$seasar$dao$impl$DefaultTest$PkOnlyTable == null ? (class$org$seasar$dao$impl$DefaultTest$PkOnlyTable = DefaultTest.class$("org.seasar.dao.impl.DefaultTest$PkOnlyTable")) : class$org$seasar$dao$impl$DefaultTest$PkOnlyTable;

        public void insert(PkOnlyTable var1);

        public List findAll();
    }

    public static class DefaultTable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String TABLE = "DEFAULT_TABLE";
        public static final String id_ID = "identity";
        private Integer id;
        private String aaa;
        private String bbb;
        private Integer versionNo;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String defaultColumn) {
            this.aaa = defaultColumn;
        }

        public String getBbb() {
            return this.bbb;
        }

        public void setBbb(String bbb) {
            this.bbb = bbb;
        }

        public Integer getVersionNo() {
            return this.versionNo;
        }

        public void setVersionNo(Integer versionNo) {
            this.versionNo = versionNo;
        }
    }

    public static interface DefaultTableDao {
        public static final Class BEAN = class$org$seasar$dao$impl$DefaultTest$DefaultTable == null ? (class$org$seasar$dao$impl$DefaultTest$DefaultTable = DefaultTest.class$("org.seasar.dao.impl.DefaultTest$DefaultTable")) : class$org$seasar$dao$impl$DefaultTest$DefaultTable;
        public static final String getDefaultTable_ARGS = "id";
        public static final String getDefaultTables_QUERY = "ORDER BY ID";

        public DefaultTable getDefaultTable(Integer var1);

        public List getDefaultTables();

        public void insert(DefaultTable var1);

        public void insertBySql(DefaultTable var1);

        public void insertBySql2(DefaultTable var1);

        public void update(DefaultTable var1);

        public int insertBatch(DefaultTable[] var1);
    }
}

