/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.Dbms;
import org.seasar.dao.IllegalAnnotationRuntimeException;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.MethodSetupFailureRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.SqlFileNotFoundRuntimeException;
import org.seasar.dao.dbms.Oracle;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.DaoNamingConventionImpl;
import org.seasar.dao.impl.DeleteAutoStaticCommand;
import org.seasar.dao.impl.DeleteBatchAutoStaticCommand;
import org.seasar.dao.impl.DtoArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.EmployeeDao;
import org.seasar.dao.impl.EmployeeDaoImpl;
import org.seasar.dao.impl.EmployeeDto;
import org.seasar.dao.impl.InsertAutoDynamicCommand;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.impl.MapArrayResultSetHandler;
import org.seasar.dao.impl.ObjectResultSetHandler;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.dao.impl.UpdateDynamicCommand;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.TextUtil;

public abstract class DaoMetaDataImplTest
extends S2DaoTestCase {
    protected abstract Class getDaoClass(String var1);

    protected abstract Class getBeanClass(String var1);

    protected abstract Object getBean(String var1);

    public void testSelectBeanList() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getAllEmployees");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        DaoMetaDataImplTest.assertEquals((String)"2", (String)"SELECT * FROM emp", (String)cmd.getSql());
        BeanListMetaDataResultSetHandler rsh = (BeanListMetaDataResultSetHandler)cmd.getResultSetHandler();
        DaoMetaDataImplTest.assertEquals((String)"3", (boolean)true, (boolean)this.getBeanClass("Employee").isAssignableFrom(rsh.getBeanMetaData().getBeanClass()));
    }

    public void testSelectBeanArray() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getAllEmployeeArray");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        BeanArrayMetaDataResultSetHandler rsh = (BeanArrayMetaDataResultSetHandler)cmd.getResultSetHandler();
        DaoMetaDataImplTest.assertEquals((String)"2", (boolean)true, (boolean)this.getBeanClass("Employee").isAssignableFrom(rsh.getBeanMetaData().getBeanClass()));
    }

    public void testSelectMapArray() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getAllEmployeeMap");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        DaoMetaDataImplTest.assertEquals((Object)MapArrayResultSetHandler.class, cmd.getResultSetHandler().getClass());
    }

    public void testSelectDtoArray() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("findAll");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        DtoArrayMetaDataResultSetHandler rsh = (DtoArrayMetaDataResultSetHandler)cmd.getResultSetHandler();
        DaoMetaDataImplTest.assertEquals((Object)EmployeeDto.class, (Object)rsh.getDtoMetaData().getBeanClass());
    }

    public void testPrefixTest() {
        DaoNamingConventionImpl daoNamingConvention = new DaoNamingConventionImpl();
        daoNamingConvention.setDaoSuffixes(new String[]{"Manager"});
        daoNamingConvention.setInsertPrefixes(new String[]{"generate"});
        daoNamingConvention.setUpdatePrefixes(new String[]{"change"});
        daoNamingConvention.setDeletePrefixes(new String[]{"terminate"});
        this.setDaoNamingConvention((DaoNamingConvention)daoNamingConvention);
        Class daoClass = this.getDaoClass("Employee8Manager");
        DaoMetaDataImpl dmd = this.createDaoMetaData(daoClass);
        InsertAutoDynamicCommand cmd1 = (InsertAutoDynamicCommand)dmd.getSqlCommand("generate");
        DaoMetaDataImplTest.assertNotNull((Object)cmd1);
        UpdateAutoStaticCommand cmd2 = (UpdateAutoStaticCommand)dmd.getSqlCommand("change");
        DaoMetaDataImplTest.assertNotNull((Object)cmd2);
        System.out.println(cmd2.getSql());
        DeleteAutoStaticCommand cmd3 = (DeleteAutoStaticCommand)dmd.getSqlCommand("terminate");
        DaoMetaDataImplTest.assertNotNull((Object)cmd3);
        System.out.println(cmd3.getSql());
    }

    public void testSelectBean() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        DaoMetaDataImplTest.assertEquals((String)"2", (Object)BeanMetaDataResultSetHandler.class, cmd.getResultSetHandler().getClass());
        DaoMetaDataImplTest.assertEquals((String)"3", (String)"empno", (String)cmd.getArgNames()[0]);
    }

    public void testSelectObject() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getCount");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        DaoMetaDataImplTest.assertEquals((String)"2", (Object)ObjectResultSetHandler.class, cmd.getResultSetHandler().getClass());
        DaoMetaDataImplTest.assertEquals((String)"3", (String)"SELECT COUNT(*) FROM emp", (String)cmd.getSql());
    }

    public void testUpdate() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        UpdateDynamicCommand cmd = (UpdateDynamicCommand)dmd.getSqlCommand("update");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        DaoMetaDataImplTest.assertEquals((String)"2", (String)"employee", (String)cmd.getArgNames()[0]);
    }

    public void testInsertAutoTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.getSqlCommand("insert");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        Object emp = this.getBean("Employee");
        this.setProperty(emp, "empno", new Integer(99));
        this.setProperty(emp, "ename", "hoge");
        cmd.execute(new Object[]{emp});
    }

    protected void setProperty(Object obj, String name, Object value) {
        BeanDesc desc = BeanDescFactory.getBeanDesc(obj.getClass());
        PropertyDesc propertyDesc = desc.getPropertyDesc(name);
        propertyDesc.setValue(obj, value);
    }

    protected Object getProperty(Object obj, String name) {
        BeanDesc desc = BeanDescFactory.getBeanDesc(obj.getClass());
        PropertyDesc propertyDesc = desc.getPropertyDesc(name);
        return propertyDesc.getValue(obj);
    }

    public void testUpdateAutoTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.getSqlCommand("update");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        SelectDynamicCommand cmd2 = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        Object emp = cmd2.execute(new Object[]{new Integer(7788)});
        this.setProperty(emp, "ename", "hoge2");
        cmd.execute(new Object[]{emp});
    }

    public void testUpdateNoCheckTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.getSqlCommand("update4");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        SelectDynamicCommand cmd2 = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        Object emp = cmd2.execute(new Object[]{new Integer(7788)});
        this.setProperty(emp, "ename", "hoge4");
        this.setProperty(emp, "timestamp", Timestamp.valueOf("1995-01-23 01:23:45.678"));
        Object obj2 = cmd.execute(new Object[]{emp});
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(obj2 instanceof Integer));
        int ret = (Integer)obj2;
        DaoMetaDataImplTest.assertEquals((String)"3", (int)0, (int)ret);
    }

    public void testDeleteAutoTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.getSqlCommand("delete");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        SelectDynamicCommand cmd2 = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        Object emp = cmd2.execute(new Object[]{new Integer(7788)});
        cmd.execute(new Object[]{emp});
    }

    public void testIllegalAutoUpdateMethod() throws Exception {
        try {
            this.createDaoMetaData(this.getDaoClass("IllegalEmployeeAutoDao"));
            DaoMetaDataImplTest.fail((String)"1");
        }
        catch (MethodSetupFailureRuntimeException ex) {
            DaoMetaDataImplTest.assertTrue((String)"1", (boolean)(ex.getCause() instanceof IllegalSignatureRuntimeException));
            System.out.println(((IllegalSignatureRuntimeException)ex.getCause()).getSignature());
            System.out.println((Object)ex);
        }
    }

    public void testSelectAuto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployeeByDeptno");
        System.out.println(cmd.getSql());
    }

    public void testInsertBatchAuto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        InsertBatchAutoStaticCommand cmd = (InsertBatchAutoStaticCommand)dmd.getSqlCommand("insertBatch");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
    }

    public void testUpdateBatchAuto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        UpdateBatchAutoStaticCommand cmd = (UpdateBatchAutoStaticCommand)dmd.getSqlCommand("updateBatch");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
    }

    public void testDeleteBatchAuto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        DeleteBatchAutoStaticCommand cmd = (DeleteBatchAutoStaticCommand)dmd.getSqlCommand("deleteBatch");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
    }

    public void testCreateFindCommand() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand(null);
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testCreateFindCommand2() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand(null);
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testCreateFindCommand3() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand("select * from emp");
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testCreateFindCommand4() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand("order by empno");
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testCreateFindCommand5() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        dmd.setDbms((Dbms)new Oracle());
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.createFindCommand("empno = ?");
        System.out.println(cmd.getSql());
        DaoMetaDataImplTest.assertTrue((String)"1", (boolean)cmd.getSql().endsWith(" AND empno = ?"));
    }

    public void testCreateFindCommandByDto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand(EmployeeDto.class, null);
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employees.get(0) instanceof EmployeeDto));
    }

    public void testCreateFindCommand2ByDto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand(EmployeeDto.class, null);
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employees.get(0) instanceof EmployeeDto));
    }

    public void testCreateFindCommand3ByDto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand(EmployeeDto.class, "select * from emp");
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employees.get(0) instanceof EmployeeDto));
    }

    public void testCreateFindCommand4ByDto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindCommand(EmployeeDto.class, "order by empno");
        List employees = (List)cmd.execute(null);
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"1", (employees.size() > 0 ? 1 : 0) != 0);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employees.get(0) instanceof EmployeeDto));
    }

    public void testCreateFindBeanCommand() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindBeanCommand("empno = ?");
        Object employee = cmd.execute(new Object[]{new Integer(7788)});
        System.out.println(employee);
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)employee);
    }

    public void testCreateObjectBeanCommand() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindObjectCommand("select count(*) from emp");
        Integer count = (Integer)cmd.execute(null);
        DaoMetaDataImplTest.assertEquals((String)"1", (int)14, (int)count);
    }

    public void testCreateFindBeanCommandByDto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindBeanCommand(EmployeeDto.class, "empno = ?");
        Object employee = cmd.execute(new Object[]{new Integer(7788)});
        System.out.println(employee);
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)employee);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employee instanceof EmployeeDto));
    }

    public void testCreateFindMapCommand() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindMapCommand("empno = ?");
        Object employee = cmd.execute(new Object[]{new Integer(7788)});
        System.out.println(employee);
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)employee);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employee instanceof Map));
    }

    public void testCreateFindMapListCommand() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindMapListCommand("empno = ?");
        Object employee = cmd.execute(new Object[]{new Integer(7788)});
        System.out.println(employee);
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)employee);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employee instanceof List));
        DaoMetaDataImplTest.assertTrue((String)"3", (boolean)(((List)employee).get(0) instanceof Map));
    }

    public void testCreateFindMapArrayCommand() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.createFindMapArrayCommand("empno = ?");
        Object employee = cmd.execute(new Object[]{new Integer(7788)});
        System.out.println(employee);
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)employee);
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)(employee instanceof Map[]));
    }

    public void testSelectAutoByQuery() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.getSqlCommand("getEmployeesBySal");
        List employees = (List)cmd.execute(new Object[]{new Integer(0), new Integer(1000)});
        System.out.println(employees);
        DaoMetaDataImplTest.assertEquals((String)"1", (int)2, (int)employees.size());
    }

    public void testSelectAutoByQueryMultiIn() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployeesByEnameJob");
        System.out.println(cmd.getSql());
        ArrayList<String> enames = new ArrayList<String>();
        enames.add("SCOTT");
        enames.add("MARY");
        ArrayList<String> jobs = new ArrayList<String>();
        jobs.add("ANALYST");
        jobs.add("FREE");
        List employees = (List)cmd.execute(new Object[]{enames, jobs});
        System.out.println(employees);
        DaoMetaDataImplTest.assertEquals((String)"1", (int)1, (int)employees.size());
    }

    public void testSelectCountBySqlFile1() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getCount");
        Object obj = cmd.execute(new Object[0]);
        DaoMetaDataImplTest.assertTrue((String)"1", (boolean)(obj instanceof Integer));
        int ret = (Integer)obj;
        DaoMetaDataImplTest.assertEquals((String)"2", (int)14, (int)ret);
    }

    public void testSelectCountBySqlFile2() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getCount2");
        Object obj = cmd.execute(new Object[0]);
        DaoMetaDataImplTest.assertTrue((String)"1", (boolean)(obj instanceof Integer));
        int ret = (Integer)obj;
        DaoMetaDataImplTest.assertEquals((String)"2", (int)14, (int)ret);
    }

    public void testRelation1() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee2Dao"));
        SqlCommand cmd = dmd.getSqlCommand("getAllEmployees");
        List emps = (List)cmd.execute(null);
        System.out.println(emps);
        DaoMetaDataImplTest.assertTrue((String)"1", (emps.size() > 0 ? 1 : 0) != 0);
        Iterator it = emps.iterator();
        while (it.hasNext()) {
            Object emp = it.next();
            DaoMetaDataImplTest.assertNotNull((String)("2:" + emp.toString()), (Object)this.getProperty(emp, "department2"));
        }
    }

    public void testRelation2() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee2Dao"));
        SqlCommand cmd = dmd.getSqlCommand("getAllEmployeesOnly");
        List emps = (List)cmd.execute(null);
        System.out.println(emps);
        DaoMetaDataImplTest.assertTrue((String)"1", (emps.size() > 0 ? 1 : 0) != 0);
        Iterator it = emps.iterator();
        while (it.hasNext()) {
            Object emp = it.next();
            DaoMetaDataImplTest.assertNull((String)("2:" + emp.toString()), (Object)this.getProperty(emp, "department2"));
        }
    }

    public void testRelation3Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SqlCommand cmd = dmd.getSqlCommand("insert");
        Object emp = this.getBean("Employee");
        this.setProperty(emp, "empno", new Integer(9999));
        this.setProperty(emp, "ename", "test");
        this.setProperty(emp, "deptno", new Integer(50));
        cmd.execute(new Object[]{emp});
        cmd = dmd.getSqlCommand("getEmployee");
        emp = cmd.execute(new Object[]{new Integer(7369)});
        System.out.println(emp);
        DaoMetaDataImplTest.assertNotNull((Object)this.getProperty(emp, "department"));
        emp = cmd.execute(new Object[]{new Integer(9999)});
        System.out.println(emp);
        DaoMetaDataImplTest.assertNotNull((Object)this.getProperty(emp, "department"));
    }

    public void testGetDaoInterface() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee8Manager"));
        DaoMetaDataImplTest.assertEquals((String)"1", (Object)EmployeeDao.class, (Object)dmd.getDaoInterface(EmployeeDao.class));
        DaoMetaDataImplTest.assertEquals((String)"2", (Object)EmployeeDao.class, (Object)dmd.getDaoInterface(EmployeeDaoImpl.class));
    }

    public void testAutoSelectSqlByDto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployeesBySearchCondition");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        Object dto = this.getBean("EmployeeSearchCondition");
        this.setProperty(dto, "dname", "RESEARCH");
        List employees = (List)cmd.execute(new Object[]{dto});
        DaoMetaDataImplTest.assertTrue((String)"2", (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testAutoSelectSqlByDto2() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployeesByEmployee");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        Object dto = this.getBean("Employee");
        this.setProperty(dto, "job", "MANAGER");
        List employees = (List)cmd.execute(new Object[]{dto});
        System.out.println(employees);
    }

    public void testAutoSelectSqlByDto3() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee3Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployees");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        Object dto = this.getBean("Employee3");
        BeanDesc desc = BeanDescFactory.getBeanDesc(dto.getClass());
        PropertyDesc propertyDesc = desc.getPropertyDesc("manager");
        propertyDesc.setValue(dto, (Object)new Short(7902));
        List employees = (List)cmd.execute(new Object[]{dto});
        System.out.println(employees);
        DaoMetaDataImplTest.assertTrue((String)"2", (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testAutoSelectSqlByDto4() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee3Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployees2");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        DaoMetaDataImplTest.assertTrue((String)"2", (boolean)cmd.getSql().endsWith(" ORDER BY empno"));
    }

    public void testAutoSelectSqlByDto5() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployeesBySearchCondition2");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        Object dto = this.getBean("EmployeeSearchCondition");
        Object department = this.getBean("Department");
        this.setProperty(department, "dname", "RESEARCH");
        this.setProperty(dto, "department", department);
        List employees = (List)cmd.execute(new Object[]{dto});
        DaoMetaDataImplTest.assertTrue((String)"2", (employees.size() > 0 ? 1 : 0) != 0);
    }

    public void testAutoSelectSqlByDto6() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployeesBySearchCondition2");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        Object dto = this.getBean("EmployeeSearchCondition");
        this.setProperty(dto, "department", null);
        List employees = (List)cmd.execute(new Object[]{dto});
        DaoMetaDataImplTest.assertEquals((String)"2", (int)0, (int)employees.size());
    }

    public void testSelfReference() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee4Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        Object employee = cmd.execute(new Object[]{new Integer(7788)});
        System.out.println(employee);
        Object parent = this.getProperty(employee, "parent");
        DaoMetaDataImplTest.assertEquals((String)"2", (Object)new Long(7566L), (Object)this.getProperty(parent, "empno"));
    }

    public void testSelfMultiPk() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee5Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
    }

    public void testNotHavePrimaryKey() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("DepartmentTotalSalaryDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getTotalSalaries");
        DaoMetaDataImplTest.assertNotNull((String)"1", (Object)cmd);
        System.out.println(cmd.getSql());
        List result = (List)cmd.execute(null);
        System.out.println(result);
    }

    public void testSelectAutoFullColumnName() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeAutoDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        System.out.println(cmd.getSql());
    }

    public void testStartsWithOrderBy() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee6Dao"));
        Object condition = this.getBean("EmployeeSearchCondition");
        this.setProperty(condition, "dname", "RESEARCH");
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployees");
        System.out.println(cmd.getSql());
        cmd.execute(new Object[]{condition});
        this.setProperty(condition, "orderByString", "ENAME");
        cmd.execute(new Object[]{condition});
    }

    public void testStartsWithBeginComment() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee8Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployees");
        System.out.println(cmd.getSql());
        Object emp = this.getBean("Employee");
        List results = (List)cmd.execute(new Object[]{emp});
        DaoMetaDataImplTest.assertEquals((int)14, (int)results.size());
        emp = this.getBean("Employee");
        this.setProperty(emp, "ename", "SMITH");
        results = (List)cmd.execute(new Object[]{emp});
        DaoMetaDataImplTest.assertEquals((int)1, (int)results.size());
        emp = this.getBean("Employee");
        this.setProperty(emp, "job", "SALESMAN");
        results = (List)cmd.execute(new Object[]{emp});
        DaoMetaDataImplTest.assertEquals((int)4, (int)results.size());
        emp = this.getBean("Employee");
        this.setProperty(emp, "ename", "SMITH");
        this.setProperty(emp, "job", "CLERK");
        results = (List)cmd.execute(new Object[]{emp});
        DaoMetaDataImplTest.assertEquals((int)1, (int)results.size());
        emp = this.getBean("Employee");
        this.setProperty(emp, "ename", "a");
        this.setProperty(emp, "job", "b");
        results = (List)cmd.execute(new Object[]{emp});
        DaoMetaDataImplTest.assertEquals((int)0, (int)results.size());
    }

    public void testQueryAnnotationTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee7Dao"));
        SelectDynamicCommand cmd1 = (SelectDynamicCommand)dmd.getSqlCommand("getCount");
        UpdateDynamicCommand cmd2 = (UpdateDynamicCommand)dmd.getSqlCommand("deleteEmployee");
        System.out.println(cmd1.getSql());
        System.out.println(cmd2.getSql());
        DaoMetaDataImplTest.assertEquals((Object)new Integer(14), (Object)cmd1.execute(null));
        DaoMetaDataImplTest.assertEquals((Object)new Integer(1), (Object)cmd2.execute(new Object[]{new Integer(7369)}));
        DaoMetaDataImplTest.assertEquals((Object)new Integer(13), (Object)cmd1.execute(null));
    }

    public void testDaoExtend1() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeDaoImpl"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        String expected = TextUtil.readText((String)(EmployeeDao.class.getPackage().getName().replace('.', '/') + "/" + "EmployeeDao_getEmployee.sql"));
        DaoMetaDataImplTest.assertEquals((String)expected, (String)cmd.getSql());
    }

    public void testDaoExtend2() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("EmployeeExDao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployee");
        String expected = TextUtil.readText((String)(EmployeeDao.class.getPackage().getName().replace('.', '/') + "/" + "EmployeeDao_getEmployee.sql"));
        DaoMetaDataImplTest.assertEquals((String)expected, (String)cmd.getSql());
    }

    public void testUsingColumnAnnotationForSql_Insert() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee9Dao"));
        InsertAutoDynamicCommand cmd = (InsertAutoDynamicCommand)dmd.getSqlCommand("insert");
        Object bean = this.getBean("Employee9");
        this.setProperty(bean, "empno", new Integer(321));
        this.setProperty(bean, "ename", "foo");
        PropertyType[] propertyTypes = cmd.createInsertPropertyTypes(cmd.getBeanMetaData(), bean, cmd.getPropertyNames());
        String sql = cmd.createInsertSql(cmd.getBeanMetaData(), propertyTypes);
        System.out.println(sql);
        DaoMetaDataImplTest.assertEquals((String)sql, (boolean)true, (sql.indexOf("eNaMe") > -1 ? 1 : 0) != 0);
    }

    public void testUsingColumnAnnotationForSql_Update() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee9Dao"));
        UpdateAutoStaticCommand cmd = (UpdateAutoStaticCommand)dmd.getSqlCommand("update");
        String sql = cmd.getSql();
        System.out.println(sql);
        DaoMetaDataImplTest.assertEquals((String)sql, (boolean)true, (sql.indexOf("eNaMe") > -1 ? 1 : 0) != 0);
    }

    public void testUsingColumnAnnotationForSql_Select() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee9Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("findBy");
        String sql = cmd.getSql();
        System.out.println(sql);
        int pos = sql.indexOf("WHERE");
        String before = sql.substring(0, pos);
        String after = sql.substring(pos);
        DaoMetaDataImplTest.assertEquals((String)before, (boolean)true, (before.indexOf("EMP.eNaMe") > -1 ? 1 : 0) != 0);
        DaoMetaDataImplTest.assertEquals((String)after, (boolean)true, (after.indexOf("EMP.eNaMe") > -1 ? 1 : 0) != 0);
    }

    public void testUsingColumnAnnotationForSql_SelectDto() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee9Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("findByEname");
        String sql = cmd.getSql();
        System.out.println(sql);
        int pos = sql.indexOf("WHERE");
        String before = sql.substring(0, pos);
        String after = sql.substring(pos);
        DaoMetaDataImplTest.assertEquals((String)before, (boolean)true, (before.indexOf("EMP.eNaMe") > -1 ? 1 : 0) != 0);
        DaoMetaDataImplTest.assertEquals((String)after, (boolean)true, (after.indexOf("EMP.eName") > -1 ? 1 : 0) != 0);
    }

    public void testSelectWithNullArgs() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(this.getDaoClass("Employee10Dao"));
        SelectDynamicCommand cmd = (SelectDynamicCommand)dmd.getSqlCommand("getEmployeesByJob");
        List emps = (List)cmd.execute(new Object[]{null});
        DaoMetaDataImplTest.assertEquals((int)14, (int)emps.size());
    }

    public void testNoSqlFile() throws Exception {
        Class daoClass = this.getDaoClass("Employee11Dao");
        try {
            this.createDaoMetaData(daoClass);
            DaoMetaDataImplTest.fail();
        }
        catch (MethodSetupFailureRuntimeException e) {
            System.out.println(e.getMessage());
            SqlFileNotFoundRuntimeException cause = (SqlFileNotFoundRuntimeException)e.getCause();
            DaoMetaDataImplTest.assertEquals((String)"EDAO0025", (String)cause.getMessageCode());
        }
    }

    public void testDeleteByQuery() throws Exception {
        Class daoClass = this.getDaoClass("Employee12Dao");
        DaoMetaDataImpl metaData = this.createDaoMetaData(daoClass);
        UpdateDynamicCommand cmd = (UpdateDynamicCommand)metaData.getSqlCommand("delete");
        DaoMetaDataImplTest.assertEquals((String)"DELETE FROM EMP WHERE EMPNO = /*no*/1111", (String)cmd.getSql());
        cmd = (UpdateDynamicCommand)metaData.getSqlCommand("deleteNoWhere");
        DaoMetaDataImplTest.assertEquals((String)"DELETE FROM EMP WHERE EMPNO = ?", (String)cmd.getSql());
    }

    public void testAssertAnnotation() throws Exception {
        Class daoClass = this.getDaoClass("Employee13Dao");
        try {
            this.createDaoMetaData(daoClass);
        }
        catch (MethodSetupFailureRuntimeException e) {
            IllegalAnnotationRuntimeException cause = (IllegalAnnotationRuntimeException)e.getCause();
            System.out.println(cause);
            DaoMetaDataImplTest.assertEquals((String)"EDAO0026", (String)cause.getMessageCode());
        }
    }

    public void testAssertAnnotation2() throws Exception {
        Class daoClass = this.getDaoClass("Employee14Dao");
        try {
            this.createDaoMetaData(daoClass);
        }
        catch (MethodSetupFailureRuntimeException e) {
            IllegalAnnotationRuntimeException cause = (IllegalAnnotationRuntimeException)e.getCause();
            System.out.println(cause);
            DaoMetaDataImplTest.assertEquals((String)"EDAO0026", (String)cause.getMessageCode());
        }
    }
}

