/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Method;
import junit.textui.TestRunner;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.NullBean;
import org.seasar.dao.impl.AbstractDao;
import org.seasar.dao.impl.Employee;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class DaoAnnotationReaderImplTest
extends S2TestCase {
    protected AnnotationReaderFactory readerFactory;

    public DaoAnnotationReaderImplTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)DaoAnnotationReaderImplTest.class);
    }

    public void setUp() {
        this.include("FieldDaoMetaDataImplTest.dicon");
    }

    protected Class getDaoClass(String className) {
        if (className.equals("AnnotationTestDaoImpl")) {
            return AnnotationTestDaoImpl.class;
        }
        if (className.equals("DummyDao")) {
            return DummyDao.class;
        }
        throw new RuntimeException("unkown dao class " + className);
    }

    public void testGetBean() {
        BeanDesc beanDesc1 = BeanDescFactory.getBeanDesc((Class)this.getDaoClass("AnnotationTestDaoImpl"));
        DaoAnnotationReader reader1 = this.readerFactory.createDaoAnnotationReader(beanDesc1);
        DaoAnnotationReaderImplTest.assertEquals((Object)Employee.class, (Object)reader1.getBeanClass());
    }

    public void testGetNullBean() {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getDaoClass("DummyDao"));
        DaoAnnotationReader reader = this.readerFactory.createDaoAnnotationReader(beanDesc);
        DaoAnnotationReaderImplTest.assertEquals((Object)NullBean.class, (Object)reader.getBeanClass());
    }

    public void testGetArgNames() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getDaoClass("AnnotationTestDaoImpl"));
        DaoAnnotationReader reader = this.readerFactory.createDaoAnnotationReader(beanDesc);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (Object)Employee.class, (Object)reader.getBeanClass());
        Method method = beanDesc.getMethods("withArgumentAnnotaion")[0];
        String[] names = reader.getArgNames(method);
        DaoAnnotationReaderImplTest.assertEquals((String)"2", (int)2, (int)names.length);
        DaoAnnotationReaderImplTest.assertEquals((String)"2", (String)"arg1", (String)names[0]);
        DaoAnnotationReaderImplTest.assertEquals((String)"2", (String)"arg2", (String)names[1]);
        Method method2 = beanDesc.getMethods("withNoAnnotaion")[0];
        String[] names2 = reader.getArgNames(method2);
        DaoAnnotationReaderImplTest.assertEquals((String)"3", (int)0, (int)names2.length);
        Method method3 = beanDesc.getMethods("subclassMethod")[0];
        String[] names3 = reader.getArgNames(method3);
        DaoAnnotationReaderImplTest.assertEquals((String)"3", (int)1, (int)names3.length);
    }

    public void testGetQuery() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getDaoClass("AnnotationTestDaoImpl"));
        DaoAnnotationReader reader = this.readerFactory.createDaoAnnotationReader(beanDesc);
        Method method1 = beanDesc.getMethods("withQueryAnnotaion")[0];
        String queryq = reader.getQuery(method1);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"arg1 = /*arg1*/'dummy'", (String)queryq);
        Method method2 = beanDesc.getMethods("withNoAnnotaion")[0];
        String query2 = reader.getQuery(method2);
        DaoAnnotationReaderImplTest.assertNull((String)"1", (Object)query2);
        Method method3 = beanDesc.getMethods("subclassMethod")[0];
        String[] names3 = reader.getArgNames(method3);
        DaoAnnotationReaderImplTest.assertEquals((String)"3", (int)1, (int)names3.length);
    }

    public void testGetPersistentProps() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getDaoClass("AnnotationTestDaoImpl"));
        DaoAnnotationReader reader = this.readerFactory.createDaoAnnotationReader(beanDesc);
        Method method1 = beanDesc.getMethods("withPersistentProps")[0];
        String[] props1 = reader.getPersistentProps(method1);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (int)2, (int)props1.length);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop1", (String)props1[0]);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop2", (String)props1[1]);
        Method method2 = beanDesc.getMethods("withNoAnnotaion")[0];
        String[] props2 = reader.getPersistentProps(method2);
        DaoAnnotationReaderImplTest.assertNull((String)"2", (Object)props2);
        Method method3 = beanDesc.getMethods("subclassMethod")[0];
        String[] props3 = reader.getPersistentProps(method3);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (int)2, (int)props3.length);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop1", (String)props3[0]);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop2", (String)props3[1]);
    }

    public void testGetNoPersistentProps() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getDaoClass("AnnotationTestDaoImpl"));
        DaoAnnotationReader reader = this.readerFactory.createDaoAnnotationReader(beanDesc);
        Method method1 = beanDesc.getMethods("withNoPersistentProps")[0];
        String[] props1 = reader.getNoPersistentProps(method1);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (int)2, (int)props1.length);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop1", (String)props1[0]);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop2", (String)props1[1]);
        Method method2 = beanDesc.getMethods("withNoAnnotaion")[0];
        String[] props2 = reader.getNoPersistentProps(method2);
        DaoAnnotationReaderImplTest.assertNull((String)"2", (Object)props2);
        Method method3 = beanDesc.getMethods("subclassMethod2")[0];
        String[] props3 = reader.getNoPersistentProps(method3);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (int)2, (int)props3.length);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop1", (String)props3[0]);
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"prop2", (String)props3[1]);
    }

    public void testGetSql() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getDaoClass("AnnotationTestDaoImpl"));
        DaoAnnotationReader reader = this.readerFactory.createDaoAnnotationReader(beanDesc);
        Method method1 = beanDesc.getMethods("subclassMethod2")[0];
        String sql = reader.getSQL(method1, "mysql");
        DaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"SELECT * FROM emp", (String)sql);
    }

    public static abstract class AnnotationTestDaoImpl
    extends AbstractDao
    implements AnnotationTestDao {
        public static String subclassMethod_ARGS = "arg1";
        public static String subclassMethod_QUERY = "arg1 = /*arg1*/'dummy'";
        public static String subclassMethod_PERSISTENT_PROPS = "prop1 , prop2";
        public static String subclassMethod2_NO_PERSISTENT_PROPS = "prop1 , prop2";
        public static String subclassMethod2_SQL = "SELECT * FROM emp";

        public AnnotationTestDaoImpl(DaoMetaDataFactory factory) {
            super(factory);
        }

        public Employee[] getEmployeesByDeptno(int deptno) {
            return (Employee[])this.getEntityManager().findArray("deptno = ?", (Object)new Integer(deptno));
        }

        public abstract Employee subclassMethod(String var1);

        public abstract Employee subclassMethod2(String var1);
    }

    public static interface DummyDao {
    }

    public static interface AnnotationTestDao {
        public static final Class BEAN = class$org$seasar$dao$impl$Employee == null ? (class$org$seasar$dao$impl$Employee = DaoAnnotationReaderImplTest.class$("org.seasar.dao.impl.Employee")) : class$org$seasar$dao$impl$Employee;
        public static final String withArgumentAnnotaion_ARGS = "arg1 , arg2 ";
        public static final String withQueryAnnotaion_QUERY = "arg1 = /*arg1*/'dummy'";
        public static final String withPersistentProps_PERSISTENT_PROPS = "prop1 , prop2";
        public static final String withNoPersistentProps_NO_PERSISTENT_PROPS = "prop1 , prop2";
        public static final String withSQLAnnotaion_mysql_SQL = "SELECT * FROM emp1";
        public static final String withSQLAnnotaion_SQL = "SELECT * FROM emp2";

        public Employee withArgumentAnnotaion(int var1, String var2);

        public Employee withQueryAnnotaion(int var1);

        public Employee withPersistentProps(int var1);

        public Employee withNoPersistentProps(int var1);

        public Employee withSQLAnnotaion();

        public Employee withNoAnnotaion(int var1);
    }
}

