/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.TableNaming;
import org.seasar.dao.impl.BeanMetaDataFactoryImpl;
import org.seasar.dao.impl.DecamelizeTableNaming;
import org.seasar.dao.impl.NoPkTable;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.jdbc.PropertyType;

public abstract class BeanMetaDataImplTest
extends S2DaoTestCase {
    protected void setUp() throws Exception {
        this.include("j2ee.dicon");
    }

    protected abstract Class getBeanClass(String var1);

    public void testSetup() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("MyBean"));
        BeanMetaDataImplTest.assertEquals((String)"1", (String)"MyBean", (String)bmd.getTableName());
        BeanMetaDataImplTest.assertEquals((String)"2", (int)3, (int)bmd.getPropertyTypeSize());
        PropertyType aaa = bmd.getPropertyType("aaa");
        BeanMetaDataImplTest.assertEquals((String)"3", (String)"aaa", (String)aaa.getColumnName());
        PropertyType bbb = bmd.getPropertyType("bbb");
        BeanMetaDataImplTest.assertEquals((String)"4", (String)"myBbb", (String)bbb.getColumnName());
        BeanMetaDataImplTest.assertEquals((String)"5", (int)1, (int)bmd.getRelationPropertyTypeSize());
        RelationPropertyType rpt = bmd.getRelationPropertyType(0);
        BeanMetaDataImplTest.assertEquals((String)"6", (int)1, (int)rpt.getKeySize());
        BeanMetaDataImplTest.assertEquals((String)"7", (String)"ddd", (String)rpt.getMyKey(0));
        BeanMetaDataImplTest.assertEquals((String)"8", (String)"id", (String)rpt.getYourKey(0));
        BeanMetaDataImplTest.assertNotNull((String)"9", (Object)bmd.getIdentifierGenerator(0));
        BeanMetaDataImplTest.assertEquals((String)"10", (int)1, (int)bmd.getPrimaryKeySize());
        BeanMetaDataImplTest.assertEquals((String)"11", (String)"aaa", (String)bmd.getPrimaryKey(0));
    }

    public void testSetupDatabaseMetaData() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Employee"));
        PropertyType empno = bmd.getPropertyType("empno");
        BeanMetaDataImplTest.assertEquals((String)"1", (boolean)true, (boolean)empno.isPrimaryKey());
        BeanMetaDataImplTest.assertEquals((String)"2", (boolean)true, (boolean)empno.isPersistent());
        PropertyType ename = bmd.getPropertyType("ename");
        BeanMetaDataImplTest.assertEquals((String)"3", (boolean)false, (boolean)ename.isPrimaryKey());
        PropertyType dummy = bmd.getPropertyType("dummy");
        BeanMetaDataImplTest.assertEquals((String)"4", (boolean)false, (boolean)dummy.isPersistent());
    }

    public void testSetupAutoSelectList() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Department"));
        BeanMetaData bmd2 = this.createBeanMetaData(this.getBeanClass("Employee"));
        String sql = bmd.getAutoSelectList();
        String sql2 = bmd2.getAutoSelectList();
        System.out.println(sql);
        System.out.println(sql2);
        BeanMetaDataImplTest.assertTrue((String)"1", (sql2.indexOf("EMP.deptno") > 0 ? 1 : 0) != 0);
        BeanMetaDataImplTest.assertTrue((String)"2", (sql2.indexOf("department.deptno AS deptno_0") > 0 ? 1 : 0) != 0);
        BeanMetaDataImplTest.assertTrue((String)"3", (sql2.indexOf("dummy_0") < 0 ? 1 : 0) != 0);
    }

    public void testConvertFullColumnName() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Employee"));
        BeanMetaDataImplTest.assertEquals((String)"1", (String)"EMP.empno", (String)bmd.convertFullColumnName("empno"));
        BeanMetaDataImplTest.assertEquals((String)"2", (String)"department.dname", (String)bmd.convertFullColumnName("dname_0"));
    }

    public void testHasPropertyTypeByAliasName() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Employee"));
        BeanMetaDataImplTest.assertEquals((String)"1", (boolean)true, (boolean)bmd.hasPropertyTypeByAliasName("empno"));
        BeanMetaDataImplTest.assertEquals((String)"2", (boolean)true, (boolean)bmd.hasPropertyTypeByAliasName("dname_0"));
        BeanMetaDataImplTest.assertEquals((String)"3", (boolean)false, (boolean)bmd.hasPropertyTypeByAliasName("xxx"));
        BeanMetaDataImplTest.assertEquals((String)"4", (boolean)false, (boolean)bmd.hasPropertyTypeByAliasName("xxx_10"));
        BeanMetaDataImplTest.assertEquals((String)"5", (boolean)false, (boolean)bmd.hasPropertyTypeByAliasName("xxx_0"));
    }

    public void testGetPropertyTypeByAliasName() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Employee"));
        BeanMetaDataImplTest.assertNotNull((String)"1", (Object)bmd.getPropertyTypeByAliasName("empno"));
        BeanMetaDataImplTest.assertNotNull((String)"2", (Object)bmd.getPropertyTypeByAliasName("dname_0"));
    }

    public void testSelfReference() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Employee4"));
        RelationPropertyType rpt = bmd.getRelationPropertyType("parent");
        BeanMetaDataImplTest.assertEquals((String)"1", (boolean)true, (boolean)this.getBeanClass("Employee4").isAssignableFrom(rpt.getBeanMetaData().getBeanClass()));
    }

    public void testNoPersistentPropsEmpty() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Ddd"));
        PropertyType pt = bmd.getPropertyType("name");
        BeanMetaDataImplTest.assertEquals((String)"1", (boolean)false, (boolean)pt.isPersistent());
    }

    public void testNoPersistentPropsDefined() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Eee"));
        PropertyType pt = bmd.getPropertyType("name");
        BeanMetaDataImplTest.assertEquals((String)"1", (boolean)false, (boolean)pt.isPersistent());
    }

    public void testPrimaryKeyForIdentifier() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("IdentityTable"));
        BeanMetaDataImplTest.assertEquals((String)"1", (String)"id", (String)bmd.getPrimaryKey(0));
    }

    public void testGetVersionNoPropertyName() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Fff"));
        BeanMetaDataImplTest.assertEquals((String)"1", (String)"version", (String)bmd.getVersionNoPropertyName());
    }

    public void testGetTimestampPropertyName() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Fff"));
        BeanMetaDataImplTest.assertEquals((String)"1", (String)"updated", (String)bmd.getTimestampPropertyName());
    }

    public void testGetPrimaryKeyWithoutIdAnnotation() throws Exception {
        this.runTestEmployee(this.createBeanMetaData(Employee3A.class));
    }

    public void testGetPrimaryKeyWithIdAnnotation() throws Exception {
        this.runTestEmployee(this.createBeanMetaData(Employee3B.class));
    }

    public void testConvertClassName() throws Exception {
        BeanMetaDataFactoryImpl factory = (BeanMetaDataFactoryImpl)this.getBeanMetaDataFactory();
        factory.setTableNaming((TableNaming)new DecamelizeTableNaming());
        BeanMetaData metaData = factory.createBeanMetaData(NoPkTable.class);
        BeanMetaDataImplTest.assertEquals((String)"NO_PK_TABLE", (String)metaData.getTableName());
    }

    public void testMultiIdentities() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(this.getBeanClass("Ggg"));
        BeanMetaDataImplTest.assertEquals((int)2, (int)bmd.getIdentifierGeneratorSize());
        BeanMetaDataImplTest.assertNotNull((Object)bmd.getIdentifierGenerator("id"));
        BeanMetaDataImplTest.assertNotNull((Object)bmd.getIdentifierGenerator("id2"));
    }

    private void runTestEmployee(BeanMetaData bmd) {
        BeanMetaDataImplTest.assertEquals((int)3, (int)bmd.getPropertyTypeSize());
        PropertyType pt = bmd.getPropertyType("employeeId");
        BeanMetaDataImplTest.assertEquals((String)"employeeId", (String)pt.getPropertyName());
        BeanMetaDataImplTest.assertEquals((String)"employee_id", (String)pt.getColumnName());
        pt = bmd.getPropertyType("employeeName");
        BeanMetaDataImplTest.assertEquals((String)"employeeName", (String)pt.getPropertyName());
        BeanMetaDataImplTest.assertEquals((String)"employee_name", (String)pt.getColumnName());
        pt = bmd.getPropertyType("departmentId");
        BeanMetaDataImplTest.assertEquals((String)"departmentId", (String)pt.getPropertyName());
        BeanMetaDataImplTest.assertEquals((String)"department_id", (String)pt.getColumnName());
        BeanMetaDataImplTest.assertEquals((int)1, (int)bmd.getPrimaryKeySize());
        BeanMetaDataImplTest.assertEquals((String)"employee_id", (String)bmd.getPrimaryKey(0));
    }

    public static class Employee3B
    extends Employee3A {
        public static final String employeeId_ID = "assigned";
    }

    public static class Employee3A {
        private static final long serialVersionUID = 1L;
        public static final String TABLE = "EMP3";
        private Integer employeeId;
        private String employeeName;
        private Integer departmentId;

        public Integer getDepartmentId() {
            return this.departmentId;
        }

        public void setDepartmentId(Integer departmentId) {
            this.departmentId = departmentId;
        }

        public Integer getEmployeeId() {
            return this.employeeId;
        }

        public void setEmployeeId(Integer employeeId) {
            this.employeeId = employeeId;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }

        public void setEmployeeName(String employeeName) {
            this.employeeName = employeeName;
        }
    }
}

