/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.id;

import org.seasar.dao.Dbms;
import org.seasar.dao.dbms.HSQL;
import org.seasar.dao.id.Hoge;
import org.seasar.dao.id.SequenceIdentifierGenerator;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class SequenceIdentifierGeneratorTest
extends S2TestCase {
    protected void setUp() throws Exception {
        this.include("j2ee.dicon");
    }

    public void testGenerateTx() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)Hoge.class);
        PropertyDesc propertyDesc = beanDesc.getPropertyDesc("id");
        PropertyTypeImpl propertyType = new PropertyTypeImpl(propertyDesc, ValueTypes.getValueType(Integer.TYPE));
        SequenceIdentifierGenerator generator = new SequenceIdentifierGenerator((PropertyType)propertyType, (Dbms)new HSQL());
        generator.setSequenceName("myseq");
        Hoge hoge = new Hoge();
        generator.setIdentifier((Object)hoge, this.getDataSource());
        System.out.println(hoge.getId());
        SequenceIdentifierGeneratorTest.assertTrue((String)"1", (hoge.getId() > 0 ? 1 : 0) != 0);
    }

    public void testGenerate_allocationSizeTx() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)Hoge.class);
        PropertyDesc propertyDesc = beanDesc.getPropertyDesc("id");
        PropertyTypeImpl propertyType = new PropertyTypeImpl(propertyDesc, ValueTypes.getValueType(Integer.TYPE));
        SequenceIdentifierGenerator generator = new SequenceIdentifierGenerator((PropertyType)propertyType, (Dbms)new HSQL());
        generator.setSequenceName("myseq2");
        generator.setAllocationSize(10L);
        Hoge hoge = new Hoge();
        generator.setIdentifier((Object)hoge, this.getDataSource());
        System.out.println(hoge.getId());
        SequenceIdentifierGeneratorTest.assertTrue((hoge.getId() > 0 ? 1 : 0) != 0);
        int prev = hoge.getId();
        for (int i = 0; i < 31; ++i) {
            generator.setIdentifier((Object)hoge, this.getDataSource());
            System.out.println(hoge.getId());
            SequenceIdentifierGeneratorTest.assertTrue((hoge.getId() > prev ? 1 : 0) != 0);
            prev = hoge.getId();
        }
    }
}

