/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.id;

import junit.textui.TestRunner;
import org.seasar.dao.Dbms;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.dbms.HSQL;
import org.seasar.dao.id.AssignedIdentifierGenerator;
import org.seasar.dao.id.Hoge;
import org.seasar.dao.id.IdentifierGeneratorFactory;
import org.seasar.dao.id.IdentityIdentifierGenerator;
import org.seasar.dao.id.SequenceIdentifierGenerator;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class IdentifierGeneratorFactoryTest
extends S2TestCase {
    public IdentifierGeneratorFactoryTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)IdentifierGeneratorFactoryTest.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testCreateIdentifierGenerator() throws Exception {
        HSQL dbms = new HSQL();
        Hoge hoge = new Hoge();
        hoge.setId(1);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)Hoge.class);
        PropertyDesc propertyDesc = beanDesc.getPropertyDesc("id");
        PropertyTypeImpl propertyType = new PropertyTypeImpl(propertyDesc, ValueTypes.getValueType(Integer.TYPE));
        IdentifierGenerator generator = IdentifierGeneratorFactory.createIdentifierGenerator((PropertyType)propertyType, (Dbms)dbms, null);
        IdentifierGeneratorFactoryTest.assertEquals((String)"1", (Object)AssignedIdentifierGenerator.class, generator.getClass());
        generator = IdentifierGeneratorFactory.createIdentifierGenerator((PropertyType)propertyType, (Dbms)dbms, (String)"identity");
        IdentifierGeneratorFactoryTest.assertEquals((String)"2", (Object)IdentityIdentifierGenerator.class, generator.getClass());
        generator = IdentifierGeneratorFactory.createIdentifierGenerator((PropertyType)propertyType, (Dbms)dbms, (String)"sequence, sequenceName = myseq");
        IdentifierGeneratorFactoryTest.assertEquals((String)"3", (String)"myseq", (String)((SequenceIdentifierGenerator)generator).getSequenceName());
        generator = IdentifierGeneratorFactory.createIdentifierGenerator((PropertyType)propertyType, (Dbms)dbms, (String)"sequence, sequenceName = myseq, allocationSize = 10");
        IdentifierGeneratorFactoryTest.assertEquals((String)"4", (long)10L, (long)((SequenceIdentifierGenerator)generator).getAllocationSize());
    }
}

