/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.xml;

import junit.framework.TestCase;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.framework.xml.TagHandler;
import org.seasar.framework.xml.TagHandlerContext;
import org.seasar.framework.xml.TagHandlerRule;
import org.xml.sax.Attributes;

public class SaxHandlerTest
extends TestCase {
    private static final String XML_FILE_NAME = "org/seasar/framework/xml/test1.xml";
    private TagHandlerRule rule_;

    public void testStart() throws Exception {
        this.rule_.addTagHandler("/tag1", new TagHandler(){
            private static final long serialVersionUID = -4675761325253965494L;

            public void start(TagHandlerContext ctx, Attributes attributes) {
                ctx.push((Object)attributes.getValue("attr1"));
            }
        });
        SaxHandler handler = new SaxHandler(this.rule_);
        SaxHandlerParser parser = new SaxHandlerParser(handler);
        SaxHandlerTest.assertEquals((String)"1", (Object)"aaa", (Object)parser.parse(XML_FILE_NAME));
    }

    public void testAppendBody() throws Exception {
        final StringBuffer buf = new StringBuffer();
        this.rule_.addTagHandler("/tag1", new TagHandler(){
            private static final long serialVersionUID = -4847079118886382658L;

            public void appendBody(TagHandlerContext ctx, String body) {
                buf.append("[" + body + "]");
            }
        });
        SaxHandler handler = new SaxHandler(this.rule_);
        SaxHandlerParser parser = new SaxHandlerParser(handler);
        parser.parse(XML_FILE_NAME);
        System.out.println(buf);
        SaxHandlerTest.assertEquals((String)"1", (String)"[111][222][333]", (String)buf.toString());
    }

    public void testAppendBody2() throws Exception {
        final StringBuffer buf = new StringBuffer();
        this.rule_.addTagHandler("tag1", new TagHandler(){
            private static final long serialVersionUID = -8151502830088127159L;

            public void appendBody(TagHandlerContext ctx, String body) {
                buf.append("[" + body + "]");
            }
        });
        SaxHandler handler = new SaxHandler(this.rule_);
        SaxHandlerParser parser = new SaxHandlerParser(handler);
        parser.parse(XML_FILE_NAME);
        System.out.println(buf);
        SaxHandlerTest.assertEquals((String)"1", (String)"[111][222][333]", (String)buf.toString());
    }

    public void testAppendBody3() throws Exception {
        final StringBuffer buf = new StringBuffer();
        this.rule_.addTagHandler("/tag1/tag3/tag4", new TagHandler(){
            private static final long serialVersionUID = 7554102451258851145L;

            public void appendBody(TagHandlerContext ctx, String body) {
                buf.append("[" + body + "]");
            }
        });
        SaxHandler handler = new SaxHandler(this.rule_);
        SaxHandlerParser parser = new SaxHandlerParser(handler);
        parser.parse(XML_FILE_NAME);
        System.out.println(buf);
        SaxHandlerTest.assertEquals((String)"1", (String)"[eee]", (String)buf.toString());
    }

    public void testEnd() throws Exception {
        this.rule_.addTagHandler("/tag1/tag2", new TagHandler(){
            private static final long serialVersionUID = -549136729563029588L;

            public void end(TagHandlerContext ctx, String body) {
                ctx.push((Object)body);
            }
        });
        SaxHandler handler = new SaxHandler(this.rule_);
        SaxHandlerParser parser = new SaxHandlerParser(handler);
        Object result = parser.parse(XML_FILE_NAME);
        SaxHandlerTest.assertEquals((String)"1", (Object)"c c", (Object)result);
    }

    public void testException() throws Exception {
        this.rule_.addTagHandler("/tag1/tag3", new TagHandler(){
            private static final long serialVersionUID = -7435868325103101164L;

            public void start(TagHandlerContext ctx, Attributes attributes) {
                throw new RuntimeException("testException");
            }
        });
        try {
            SaxHandler handler = new SaxHandler(this.rule_);
            SaxHandlerParser parser = new SaxHandlerParser(handler);
            parser.parse(XML_FILE_NAME);
            SaxHandlerTest.fail((String)"1");
        }
        catch (RuntimeException ex) {
            System.out.println(ex);
        }
    }

    public void testTagMatching() throws Exception {
        TagHandler eh = new TagHandler(){
            private static final long serialVersionUID = 313427123032197039L;

            public void start(TagHandlerContext ctx, Attributes attributes) {
                System.out.println(ctx.getDetailPath());
            }
        };
        this.rule_.addTagHandler("tag1", eh);
        this.rule_.addTagHandler("tag2", eh);
        this.rule_.addTagHandler("tag3", eh);
        this.rule_.addTagHandler("tag4", eh);
        this.rule_.addTagHandler("tag5", eh);
        System.out.println("tagMatching");
        SaxHandler handler = new SaxHandler(this.rule_);
        SaxHandlerParser parser = new SaxHandlerParser(handler);
        parser.parse(XML_FILE_NAME);
    }

    protected void setUp() throws Exception {
        this.rule_ = new TagHandlerRule();
    }
}

