/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import junit.framework.TestCase;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.URLUtil;

public class URLUtilTest
extends TestCase {
    public void testDisableURLCaches() throws Exception {
        String root = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass()).getCanonicalPath();
        String srcJar = root + "/org/seasar/framework/util/test.jar";
        String destJar = root + "/org/seasar/framework/util/test2.jar";
        File dest = new File(destJar);
        if (dest.exists()) {
            dest.delete();
        }
        dest.createNewFile();
        FileUtil.copy((File)new File(srcJar), (File)dest);
        new URL("http://a").openConnection().setDefaultUseCaches(true);
        URLUtil.disableURLCaches();
        URL url = new URL("jar:" + dest.toURI().toURL() + "!/META-INF/MANIFEST.MF");
        URLConnection connection = url.openConnection();
        InputStream stream = connection.getInputStream();
        stream.close();
        URLUtilTest.assertTrue((boolean)dest.delete());
    }

    public void testEncode() throws Exception {
        URLUtilTest.assertEquals((String)"Program+Files", (String)URLUtil.encode((String)"Program Files", (String)"UTF-8"));
    }

    public void testDecode() throws Exception {
        URLUtilTest.assertEquals((String)"Program Files", (String)URLUtil.decode((String)"Program+Files", (String)"UTF-8"));
    }

    public void testToCanonicalProtocol() throws Exception {
        URLUtilTest.assertEquals((String)"jar", (String)URLUtil.toCanonicalProtocol((String)"wsjar"));
        URLUtilTest.assertEquals((String)"jar", (String)URLUtil.toCanonicalProtocol((String)"jar"));
        URLUtilTest.assertEquals((String)"zip", (String)URLUtil.toCanonicalProtocol((String)"zip"));
        URLUtilTest.assertEquals((String)"file", (String)URLUtil.toCanonicalProtocol((String)"file"));
    }

    public void testToFile() throws Exception {
        File file = new File("Program Files/hoge.txt");
        URL url = file.toURL();
        URLUtilTest.assertEquals((Object)file.getAbsoluteFile(), (Object)URLUtil.toFile((URL)url));
        URLUtilTest.assertEquals((Object)file.getAbsoluteFile(), (Object)URLUtil.toFile((URL)new URL("file:Program%20Files/hoge.txt")));
    }
}

