/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import junit.extensions.TestDecorator;
import junit.framework.TestCase;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceTraversal;
import org.seasar.framework.util.ResourcesUtil;
import org.seasar.framework.util.xxx.DummyTest;

public class ResourcesUtilTest
extends TestCase {
    public void testFromClass_FileSystem() throws Exception {
        ResourcesUtil.Resources resources = ResourcesUtil.getResourcesType((Class)DummyTest.class);
        ResourcesUtilTest.assertNotNull((Object)resources);
        ResourcesUtilTest.assertTrue((boolean)(resources instanceof ResourcesUtil.FileSystemResources));
        ResourcesUtilTest.assertTrue((boolean)resources.isExistClass(DummyTest.class.getName()));
        ResourcesUtilTest.assertFalse((boolean)resources.isExistClass(TestCase.class.getName()));
        final HashSet set = new HashSet();
        resources.forEach(new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                set.add(ClassUtil.concatName((String)packageName, (String)shortClassName));
            }
        });
        ResourcesUtilTest.assertTrue((set.size() > 0 ? 1 : 0) != 0);
        ResourcesUtilTest.assertTrue((boolean)set.contains(DummyTest.class.getName()));
        ResourcesUtilTest.assertTrue((boolean)set.contains(ResourcesUtilTest.class.getName()));
        ResourcesUtilTest.assertFalse((boolean)set.contains(TestCase.class.getName()));
    }

    public void testFromClass_JarFile() throws Exception {
        ResourcesUtil.Resources resources = ResourcesUtil.getResourcesType((Class)TestCase.class);
        ResourcesUtilTest.assertNotNull((Object)resources);
        ResourcesUtilTest.assertTrue((boolean)(resources instanceof ResourcesUtil.JarFileResources));
        ResourcesUtilTest.assertTrue((boolean)resources.isExistClass(TestCase.class.getName()));
        ResourcesUtilTest.assertFalse((boolean)resources.isExistClass(DummyTest.class.getName()));
        final HashSet set = new HashSet();
        resources.forEach(new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                set.add(ClassUtil.concatName((String)packageName, (String)shortClassName));
            }
        });
        ResourcesUtilTest.assertTrue((set.size() > 0 ? 1 : 0) != 0);
        ResourcesUtilTest.assertTrue((boolean)set.contains(TestCase.class.getName()));
        ResourcesUtilTest.assertFalse((boolean)set.contains(DummyTest.class.getName()));
    }

    public void testFromDir_FileSystem() throws Exception {
        ResourcesUtil.Resources resources = ResourcesUtil.getResourcesType((String)"org/seasar/framework/util/xxx");
        ResourcesUtilTest.assertNotNull((Object)resources);
        ResourcesUtilTest.assertTrue((boolean)(resources instanceof ResourcesUtil.FileSystemResources));
        final ArrayList list = new ArrayList();
        resources.forEach(new ResourceTraversal.ResourceHandler(){

            public void processResource(String path, InputStream is) {
                list.add(path);
            }
        });
        ResourcesUtilTest.assertEquals((int)1, (int)list.size());
        ResourcesUtilTest.assertTrue((boolean)((String)list.get(0)).endsWith("DummyTest.class"));
    }

    public void testFromDir_JarFile() throws Exception {
        ResourcesUtil.Resources resources = ResourcesUtil.getResourcesType((String)"junit/textui");
        ResourcesUtilTest.assertNotNull((Object)resources);
        ResourcesUtilTest.assertTrue((boolean)(resources instanceof ResourcesUtil.JarFileResources));
        final ArrayList list = new ArrayList();
        resources.forEach(new ResourceTraversal.ResourceHandler(){

            public void processResource(String path, InputStream is) {
                list.add(path);
            }
        });
        ResourcesUtilTest.assertEquals((int)2, (int)list.size());
        ResourcesUtilTest.assertEquals((Object)"junit/textui/ResultPrinter.class", list.get(0));
        ResourcesUtilTest.assertEquals((Object)"junit/textui/TestRunner.class", list.get(1));
    }

    public void testFromRootPackage_FileSystem() throws Exception {
        ResourcesUtil.Resources[] resourcesArray = ResourcesUtil.getResourcesTypes((String)"org.seasar.framework.util.xxx");
        ResourcesUtilTest.assertNotNull((Object)resourcesArray);
        ResourcesUtilTest.assertEquals((int)1, (int)resourcesArray.length);
        ResourcesUtil.Resources resources = resourcesArray[0];
        ResourcesUtilTest.assertTrue((boolean)(resources instanceof ResourcesUtil.FileSystemResources));
        ResourcesUtilTest.assertTrue((boolean)resources.isExistClass("DummyTest"));
        ResourcesUtilTest.assertFalse((boolean)resources.isExistClass("TestCase"));
        final HashSet set = new HashSet();
        resources.forEach(new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                set.add(ClassUtil.concatName((String)packageName, (String)shortClassName));
            }
        });
        ResourcesUtilTest.assertTrue((set.size() > 0 ? 1 : 0) != 0);
        ResourcesUtilTest.assertTrue((boolean)set.contains(DummyTest.class.getName()));
        ResourcesUtilTest.assertFalse((boolean)set.contains(ResourcesUtilTest.class.getName()));
        ResourcesUtilTest.assertFalse((boolean)set.contains(TestCase.class.getName()));
    }

    public void testFromRootPackage_JarFile() throws Exception {
        ResourcesUtil.Resources[] resourcesArray = ResourcesUtil.getResourcesTypes((String)"junit.textui");
        ResourcesUtilTest.assertNotNull((Object)resourcesArray);
        ResourcesUtilTest.assertEquals((int)1, (int)resourcesArray.length);
        ResourcesUtil.Resources resources = resourcesArray[0];
        ResourcesUtilTest.assertTrue((boolean)(resources instanceof ResourcesUtil.JarFileResources));
        ResourcesUtilTest.assertTrue((boolean)resources.isExistClass("TestRunner"));
        ResourcesUtilTest.assertFalse((boolean)resources.isExistClass("DummyTest"));
        final HashSet set = new HashSet();
        resources.forEach(new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                set.add(ClassUtil.concatName((String)packageName, (String)shortClassName));
            }
        });
        ResourcesUtilTest.assertEquals((int)2, (int)set.size());
        ResourcesUtilTest.assertTrue((boolean)set.contains(ResultPrinter.class.getName()));
        ResourcesUtilTest.assertTrue((boolean)set.contains(TestRunner.class.getName()));
        ResourcesUtilTest.assertFalse((boolean)set.contains(TestDecorator.class.getName()));
    }
}

