/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.TestCase;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.util.ResourceUtil;

public class ResourceUtilTest
extends TestCase {
    public void testGetResourcePath() throws Exception {
        ResourceUtilTest.assertEquals((String)"1", (String)"aaa/bbb.xml", (String)ResourceUtil.getResourcePath((String)"aaa/bbb.xml", (String)"xml"));
        ResourceUtilTest.assertEquals((String)"2", (String)"aaa/bbb.xml", (String)ResourceUtil.getResourcePath((String)"aaa.bbb", (String)"xml"));
        ResourceUtilTest.assertEquals((String)"3", (String)"org/seasar/framework/util/ResourceUtilTest.class", (String)ResourceUtil.getResourcePath(((Object)((Object)this)).getClass()));
    }

    public void testGetResource() throws Exception {
        ResourceUtilTest.assertNotNull((Object)ResourceUtil.getResource((String)"java/lang/String.class", (String)"class"));
        ResourceUtilTest.assertNotNull((Object)ResourceUtil.getResource((String)"org/seasar"));
        try {
            ResourceUtil.getResource((String)"hoge", (String)"xml");
            ResourceUtilTest.fail((String)"2");
        }
        catch (ResourceNotFoundRuntimeException e) {
            System.out.println((Object)e);
            ResourceUtilTest.assertEquals((String)"3", (String)"hoge.xml", (String)e.getPath());
        }
        System.out.println(ResourceUtil.getResource((String)"."));
    }

    public void testGetResourceAsStreamNoException() throws Exception {
        ResourceUtilTest.assertNotNull((Object)ResourceUtil.getResourceAsStreamNoException((String)"java/lang/String.class", (String)"class"));
        ResourceUtilTest.assertNull((Object)ResourceUtil.getResourceAsStreamNoException((String)"java/lang/String2.class", (String)"class"));
    }

    public void testGetBuildDir() throws Exception {
        File file = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
        System.out.println(file);
        File file2 = ResourceUtil.getBuildDir((String)"org/seasar/framework/util/xxx");
        ResourceUtilTest.assertEquals((Object)file, (Object)file2);
        File junitJar = ResourceUtil.getBuildDir((Class)TestCase.class);
        ResourceUtilTest.assertTrue((boolean)junitJar.exists());
        URL url = junitJar.toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{url});
        loader.loadClass(TestCase.class.getName());
    }

    public void testIsExist() throws Exception {
        ResourceUtilTest.assertEquals((String)"1", (boolean)true, (boolean)ResourceUtil.isExist((String)"SSRMessages.properties"));
        ResourceUtilTest.assertEquals((String)"2", (boolean)false, (boolean)ResourceUtil.isExist((String)"hoge"));
    }

    public void testGetExtension() throws Exception {
        ResourceUtilTest.assertEquals((String)"1", (String)"xml", (String)ResourceUtil.getExtension((String)"aaa/bbb.xml"));
        ResourceUtilTest.assertEquals((String)"2", null, (String)ResourceUtil.getExtension((String)"aaa"));
    }

    public void testRemoteExtension() throws Exception {
        ResourceUtilTest.assertEquals((String)"1", (String)"aaa/bbb", (String)ResourceUtil.removeExtension((String)"aaa/bbb.xml"));
        ResourceUtilTest.assertEquals((String)"2", (String)"aaa/bbb", (String)ResourceUtil.removeExtension((String)"aaa/bbb"));
    }

    public void testToExternalForm() throws Exception {
        URL url = new File("/Program File").toURL();
        ResourceUtilTest.assertEquals((String)("file:" + this.getRoot() + "Program File"), (String)ResourceUtil.toExternalForm((URL)url));
    }

    public void testGetFileName() throws Exception {
        URL url = new File("/Program File").toURL();
        ResourceUtilTest.assertEquals((String)(this.getRoot() + "Program File"), (String)ResourceUtil.getFileName((URL)url));
        url = ResourceUtil.getResource((String)"java/lang/String.class");
        ResourceUtilTest.assertNull((Object)ResourceUtil.getFile((URL)url));
    }

    private String getRoot() throws IOException {
        String root = new File("/").getCanonicalPath().replace('\\', '/');
        if (root.startsWith("/")) {
            return root;
        }
        return "/" + root;
    }
}

