/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.util.Date;
import junit.framework.TestCase;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.HotText;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class HotTextTest
extends TestCase {
    private static final String PATH = StringUtil.replace((String)ClassUtil.getPackageName((Class)HotTextTest.class), (String)".", (String)"/") + "/HotTextTest.txt";

    public void testSetFileAndGetValue() throws Exception {
        HotText text = new HotText(PATH);
        HotTextTest.assertEquals((String)"\u3042", (String)text.getValue());
    }

    public void testSetValueAndGetValue() throws Exception {
        HotText text = new HotText();
        text.setValue("aaa");
        HotTextTest.assertEquals((String)"aaa", (String)text.getValue());
        HotTextTest.assertFalse((boolean)text.isModified());
    }

    public void testIsModified() throws Exception {
        HotText text = new HotText(PATH);
        HotTextTest.assertFalse((boolean)text.isModified());
        File file = ResourceUtil.getResourceAsFile((String)PATH);
        Thread.sleep(500L);
        file.setLastModified(new Date().getTime());
        HotTextTest.assertTrue((boolean)text.isModified());
    }

    public void xxxtestPerformance() throws Exception {
        int i;
        HotText text = new HotText(PATH);
        int count = 10000;
        long start = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            text.isModified();
        }
        System.out.println(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            text.updateValueByFile();
        }
        System.out.println(System.currentTimeMillis() - start);
    }
}

