/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;

public class ClassTraversalTest
extends TestCase {
    private static int count = 0;

    protected void setUp() throws Exception {
        count = 0;
    }

    public void testForEachJarFile() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        JarURLConnection con = (JarURLConnection)classURL.openConnection();
        ClassTraversal.forEach((JarFile)con.getJarFile(), (ClassTraversal.ClassHandler)new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                if (count < 10) {
                    System.out.println(ClassUtil.concatName((String)packageName, (String)shortClassName));
                }
                Assert.assertNotNull((Object)packageName);
                Assert.assertNotNull((Object)shortClassName);
                Assert.assertTrue((boolean)packageName.startsWith("junit"));
                count++;
            }
        });
        ClassTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    public void testForEachJarFile_withPrefix() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        JarURLConnection con = (JarURLConnection)classURL.openConnection();
        ClassTraversal.forEach((JarFile)con.getJarFile(), (String)"junit/", (ClassTraversal.ClassHandler)new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                if (count < 10) {
                    System.out.println(ClassUtil.concatName((String)packageName, (String)shortClassName));
                }
                Assert.assertNotNull((Object)packageName);
                Assert.assertNotNull((Object)shortClassName);
                Assert.assertFalse((boolean)packageName.startsWith("junit"));
                count++;
            }
        });
        ClassTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    public void testForEachZipInputStream() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        URL jarURL = new File(JarFileUtil.toJarFilePath((URL)classURL)).toURL();
        ClassTraversal.forEach((ZipInputStream)new ZipInputStream(jarURL.openStream()), (ClassTraversal.ClassHandler)new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                if (count < 10) {
                    System.out.println(ClassUtil.concatName((String)packageName, (String)shortClassName));
                }
                Assert.assertNotNull((Object)packageName);
                Assert.assertNotNull((Object)shortClassName);
                Assert.assertTrue((boolean)packageName.startsWith("junit"));
                count++;
            }
        });
        ClassTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    public void testForEachZipInputStream_withPrefix() throws Exception {
        String classFilePath = TestCase.class.getName().replace('.', '/') + ".class";
        URL classURL = ResourceUtil.getResource((String)classFilePath);
        URL jarURL = new File(JarFileUtil.toJarFilePath((URL)classURL)).toURL();
        ClassTraversal.forEach((ZipInputStream)new ZipInputStream(jarURL.openStream()), (String)"junit/", (ClassTraversal.ClassHandler)new ClassTraversal.ClassHandler(){

            public void processClass(String packageName, String shortClassName) {
                if (count < 10) {
                    System.out.println(ClassUtil.concatName((String)packageName, (String)shortClassName));
                }
                Assert.assertNotNull((Object)packageName);
                Assert.assertNotNull((Object)shortClassName);
                Assert.assertFalse((boolean)packageName.startsWith("junit"));
                count++;
            }
        });
        ClassTraversalTest.assertTrue((count > 0 ? 1 : 0) != 0);
    }
}

