/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.util.Traversal;

public class TraversalTest
extends TestCase {
    private S2Container container;

    protected void setUp() throws Exception {
        this.container = S2ContainerFactory.create((String)"org/seasar/framework/container/util/TraversalTest.dicon");
    }

    public void testForEachContainer() throws Exception {
        final ArrayList l = new ArrayList();
        Traversal.forEachContainer((S2Container)this.container, (Traversal.S2ContainerHandler)new Traversal.S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                l.add(container.getNamespace());
                return null;
            }
        });
        TraversalTest.assertEquals((String)"1", (int)4, (int)l.size());
        TraversalTest.assertEquals((String)"2", (Object)"root", l.get(0));
        TraversalTest.assertEquals((String)"3", (Object)"1", l.get(1));
        TraversalTest.assertEquals((String)"4", (Object)"2", l.get(2));
        TraversalTest.assertEquals((String)"5", (Object)"3", l.get(3));
    }

    public void testForEachContainerChildLast() throws Exception {
        final ArrayList l = new ArrayList();
        Traversal.forEachContainer((S2Container)this.container, (Traversal.S2ContainerHandler)new Traversal.S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                l.add(container.getNamespace());
                return null;
            }
        }, (boolean)false);
        TraversalTest.assertEquals((String)"1", (int)4, (int)l.size());
        TraversalTest.assertEquals((String)"2", (Object)"1", l.get(0));
        TraversalTest.assertEquals((String)"3", (Object)"3", l.get(1));
        TraversalTest.assertEquals((String)"4", (Object)"2", l.get(2));
        TraversalTest.assertEquals((String)"5", (Object)"root", l.get(3));
    }

    public void testForEachContainerFinding() throws Exception {
        String s = (String)Traversal.forEachContainer((S2Container)this.container, (Traversal.S2ContainerHandler)new Traversal.S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                return container.getNamespace();
            }
        }, (boolean)false);
        TraversalTest.assertEquals((String)"1", (String)"1", (String)s);
    }

    public void testForEachComponent() throws Exception {
        final ArrayList l = new ArrayList();
        Traversal.forEachComponent((S2Container)this.container, (Traversal.ComponentDefHandler)new Traversal.ComponentDefHandler(){

            public Object processComponent(ComponentDef componentDef) {
                l.add(componentDef.getComponentName());
                return null;
            }
        });
        TraversalTest.assertEquals((String)"1", (int)8, (int)l.size());
        TraversalTest.assertEquals((String)"2", (Object)"1", l.get(0));
        TraversalTest.assertEquals((String)"3", (Object)"2", l.get(1));
        TraversalTest.assertEquals((String)"4", (Object)"1-1", l.get(2));
        TraversalTest.assertEquals((String)"5", (Object)"1-2", l.get(3));
        TraversalTest.assertEquals((String)"6", (Object)"2-1", l.get(4));
        TraversalTest.assertEquals((String)"7", (Object)"2-2", l.get(5));
        TraversalTest.assertEquals((String)"8", (Object)"3-1", l.get(6));
        TraversalTest.assertEquals((String)"9", (Object)"3-2", l.get(7));
    }

    public void testForEachComponentChildFirst() throws Exception {
        final ArrayList l = new ArrayList();
        Traversal.forEachComponent((S2Container)this.container, (Traversal.ComponentDefHandler)new Traversal.ComponentDefHandler(){

            public Object processComponent(ComponentDef componentDef) {
                l.add(componentDef.getComponentName());
                return null;
            }
        }, (boolean)false);
        TraversalTest.assertEquals((String)"1", (int)8, (int)l.size());
        TraversalTest.assertEquals((String)"2", (Object)"1-1", l.get(0));
        TraversalTest.assertEquals((String)"3", (Object)"1-2", l.get(1));
        TraversalTest.assertEquals((String)"4", (Object)"3-1", l.get(2));
        TraversalTest.assertEquals((String)"5", (Object)"3-2", l.get(3));
        TraversalTest.assertEquals((String)"6", (Object)"2-1", l.get(4));
        TraversalTest.assertEquals((String)"7", (Object)"2-2", l.get(5));
        TraversalTest.assertEquals((String)"8", (Object)"1", l.get(6));
        TraversalTest.assertEquals((String)"9", (Object)"2", l.get(7));
    }

    public void testForEachComponentFinding() throws Exception {
        String s = (String)Traversal.forEachComponent((S2Container)this.container, (Traversal.ComponentDefHandler)new Traversal.ComponentDefHandler(){

            public Object processComponent(ComponentDef componentDef) {
                return componentDef.getComponentName();
            }
        }, (boolean)false);
        TraversalTest.assertEquals((String)"1", (String)"1-1", (String)s);
    }

    public void testForEachParentContainer() throws Exception {
        final ArrayList l = new ArrayList();
        S2Container container3 = this.container.getChild(2);
        Traversal.forEachParentContainer((S2Container)container3, (Traversal.S2ContainerHandler)new Traversal.S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                l.add(container.getNamespace());
                return null;
            }
        });
        TraversalTest.assertEquals((String)"1", (int)3, (int)l.size());
        TraversalTest.assertEquals((String)"2", (Object)"3", l.get(0));
        TraversalTest.assertEquals((String)"3", (Object)"2", l.get(1));
        TraversalTest.assertEquals((String)"4", (Object)"root", l.get(2));
    }

    public void testForEachParentContainerChildLast() throws Exception {
        final ArrayList l = new ArrayList();
        S2Container container3 = this.container.getChild(2);
        Traversal.forEachParentContainer((S2Container)container3, (Traversal.S2ContainerHandler)new Traversal.S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                l.add(container.getNamespace());
                return null;
            }
        }, (boolean)false);
        TraversalTest.assertEquals((String)"1", (int)3, (int)l.size());
        TraversalTest.assertEquals((String)"2", (Object)"root", l.get(0));
        TraversalTest.assertEquals((String)"3", (Object)"2", l.get(1));
        TraversalTest.assertEquals((String)"4", (Object)"3", l.get(2));
    }

    public void testForEachParentContainerFinding() throws Exception {
        S2Container container3 = this.container.getChild(2);
        String s = (String)Traversal.forEachParentContainer((S2Container)container3, (Traversal.S2ContainerHandler)new Traversal.S2ContainerHandler(){

            public Object processContainer(S2Container container) {
                return container.getNamespace();
            }
        }, (boolean)false);
        TraversalTest.assertEquals((String)"1", (String)"root", (String)s);
    }
}

