/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.ExternalContextComponentDefRegister;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.external.servlet.HttpServletExternalContextComponentDefRegister;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.framework.util.ResourceUtil;

public class S2ContainerImplTest
extends TestCase {
    S2Container container0;
    S2Container container1;
    S2Container container2;
    S2Container container3;
    S2Container container4;

    protected void setUp() throws Exception {
        super.setUp();
        this.container0 = new S2ContainerImpl();
        this.container0.setPath("0");
        this.container1 = new S2ContainerImpl();
        this.container1.setPath("1");
        this.container1.register(HashMap.class);
        this.container0.include(this.container1);
        this.container2 = new S2ContainerImpl();
        this.container2.setPath("2");
        this.container2.register(HashMap.class);
        this.container2.register(HashMap.class);
        this.container1.include(this.container2);
        this.container3 = new S2ContainerImpl();
        this.container3.setPath("3");
        this.container3.register(HashMap.class);
        this.container3.register(HashMap.class);
        this.container3.register(HashMap.class);
        this.container2.include(this.container3);
        this.container4 = new S2ContainerImpl();
        this.container4.setPath("4");
        this.container4.register(HashMap.class);
        this.container4.register(HashMap.class);
        this.container4.register(HashMap.class);
        this.container4.register(HashMap.class);
        this.container3.include(this.container4);
    }

    public void testRegister() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(A.class);
        container.register(B.class);
        container.register(B2.class);
        try {
            container.getComponent((Object)A.class);
            S2ContainerImplTest.fail((String)"1");
        }
        catch (TooManyRegistrationRuntimeException ex) {
            System.out.println((Object)ex);
            S2ContainerImplTest.assertEquals((String)"2", (Object)Hoge.class, (Object)ex.getKey());
            S2ContainerImplTest.assertEquals((String)"3", (int)2, (int)ex.getComponentClasses().length);
            S2ContainerImplTest.assertEquals((String)"4", (Object)B.class, (Object)ex.getComponentClasses()[0]);
            S2ContainerImplTest.assertEquals((String)"5", (Object)B2.class, (Object)ex.getComponentClasses()[1]);
        }
    }

    public void testRegisterForAlreadyRegistration() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(B.class, "B");
        ComponentDefImpl cd2 = new ComponentDefImpl(B2.class, "B");
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        try {
            container.getComponent((Object)"B");
            S2ContainerImplTest.fail((String)"1");
        }
        catch (TooManyRegistrationRuntimeException ex) {
            System.out.println((Object)ex);
            S2ContainerImplTest.assertEquals((String)"2", (Object)"B", (Object)ex.getKey());
            S2ContainerImplTest.assertEquals((String)"3", (int)2, (int)ex.getComponentClasses().length);
            S2ContainerImplTest.assertEquals((String)"4", (Object)B.class, (Object)ex.getComponentClasses()[0]);
            S2ContainerImplTest.assertEquals((String)"5", (Object)B2.class, (Object)ex.getComponentClasses()[1]);
        }
    }

    public void testInclude() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(A.class);
        S2ContainerImpl container2 = new S2ContainerImpl();
        container2.register(B.class);
        container.include((S2Container)container2);
        A a = (A)container.getComponent((Object)A.class);
        S2ContainerImplTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
        S2ContainerImplTest.assertEquals((String)"2", (int)1, (int)container2.getParentSize());
        S2ContainerImplTest.assertSame((String)"3", (Object)container, (Object)container2.getParent(0));
    }

    public void testInclude2() throws Exception {
        S2ContainerImpl root = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        child.setNamespace("aaa");
        child.register((Object)"hoge", "hoge");
        root.include((S2Container)child);
        S2ContainerImpl child2 = new S2ContainerImpl();
        child2.setNamespace("bbb");
        child2.register((Object)"hoge2", "hoge");
        S2ContainerImpl grandchild = new S2ContainerImpl();
        grandchild.setNamespace("ccc");
        grandchild.register((Object)"hoge3", "hoge");
        child2.include((S2Container)grandchild);
        root.include((S2Container)child2);
        S2ContainerImplTest.assertEquals((String)"1", (Object)"hoge", (Object)child.getComponent((Object)"hoge"));
        S2ContainerImplTest.assertEquals((String)"2", (Object)"hoge3", (Object)grandchild.getComponent((Object)"hoge"));
        S2ContainerImplTest.assertEquals((String)"3", (Object)child, (Object)root.getComponent((Object)"aaa"));
        S2ContainerImplTest.assertEquals((String)"4", (Object)child2, (Object)root.getComponent((Object)"bbb"));
        S2ContainerImplTest.assertEquals((String)"5", (Object)"hoge", (Object)root.getComponent((Object)"aaa.hoge"));
        S2ContainerImplTest.assertEquals((String)"6", (Object)"hoge2", (Object)root.getComponent((Object)"bbb.hoge"));
        S2ContainerImplTest.assertEquals((String)"7", (Object)"hoge3", (Object)root.getComponent((Object)"ccc.hoge"));
        S2ContainerImplTest.assertEquals((String)"8", (Object)"hoge", (Object)child.getComponent((Object)"aaa.hoge"));
        S2ContainerImplTest.assertEquals((String)"9", (boolean)false, (boolean)child.hasComponentDef((Object)"bbb.hoge"));
        S2ContainerImplTest.assertEquals((String)"10", (boolean)false, (boolean)child.hasComponentDef((Object)"ccc.hoge"));
        S2ContainerImplTest.assertEquals((String)"11", (Object)"hoge2", (Object)child2.getComponent((Object)"hoge"));
        S2ContainerImplTest.assertEquals((String)"12", (Object)"hoge3", (Object)child2.getComponent((Object)"ccc.hoge"));
        S2ContainerImplTest.assertEquals((String)"13", (int)0, (int)root.getComponentDefSize());
    }

    public void testInclude3() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        child.setPath("aaa.xml");
        S2ContainerImpl grandchild = new S2ContainerImpl();
        grandchild.setPath("bbb.xml");
        grandchild.setNamespace("bbb");
        child.include((S2Container)grandchild);
        container.include((S2Container)child);
        container.include((S2Container)grandchild);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)container.getComponentDef((Object)"bbb"));
    }

    public void testInclude4() throws Exception {
        S2ContainerImpl aaa = new S2ContainerImpl();
        aaa.setPath("aaa.xml");
        aaa.setNamespace("aaa");
        S2ContainerImpl bbb = new S2ContainerImpl();
        bbb.setPath("bbb.xml");
        S2ContainerImpl aaa2 = new S2ContainerImpl();
        aaa2.setPath("aaa.xml");
        aaa2.setNamespace("aaa");
        bbb.include((S2Container)aaa2);
        aaa.include((S2Container)bbb);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)aaa.getComponentDef((Object)"aaa"));
    }

    public void testInclude5() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        child.setNamespace("aaa");
        S2ContainerImpl child2 = new S2ContainerImpl();
        child2.setNamespace("aaa");
        container.include((S2Container)child);
        container.include((S2Container)child2);
        S2ContainerImplTest.assertSame((String)"1", (Object)child, (Object)container.getComponent((Object)"aaa"));
    }

    public void testInclude6() throws Exception {
        S2ContainerImpl root = new S2ContainerImpl();
        S2ContainerImpl aaa = new S2ContainerImpl();
        aaa.setPath("aaa.xml");
        aaa.setNamespace("aaa");
        S2ContainerImpl bbb = new S2ContainerImpl();
        bbb.setPath("bbb.xml");
        bbb.setNamespace("bbb");
        bbb.register((Object)new Date(), "date");
        aaa.include((S2Container)bbb);
        root.include((S2Container)aaa);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)root.getComponentDef((Object)"bbb.date"));
    }

    public void testInclude7() throws Exception {
        S2ContainerImpl root = new S2ContainerImpl();
        S2ContainerImpl aaa = new S2ContainerImpl();
        aaa.setNamespace("aaa");
        S2ContainerImpl bbb = new S2ContainerImpl();
        bbb.setNamespace("bbb");
        bbb.register((Object)new Date(0L), "date");
        S2ContainerImpl ccc = new S2ContainerImpl();
        ccc.setNamespace("ccc");
        ccc.register((Object)new Date(1L), "date");
        bbb.include((S2Container)ccc);
        aaa.include((S2Container)bbb);
        root.include((S2Container)aaa);
        S2ContainerImplTest.assertEquals((String)"1", (Object)new Date(1L), (Object)root.getComponent((Object)"aaa.bbb.ccc.date"));
        S2ContainerImplTest.assertEquals((String)"2", (Object)new Date(0L), (Object)root.getComponent((Object)"aaa.bbb.date"));
        S2ContainerImplTest.assertEquals((String)"3", (Object)new Date(0L), (Object)root.getComponent((Object)"bbb.date"));
        S2ContainerImplTest.assertEquals((String)"4", (Object)new Date(1L), (Object)root.getComponent((Object)"bbb.ccc.date"));
        S2ContainerImplTest.assertEquals((String)"5", (Object)new Date(1L), (Object)root.getComponent((Object)"ccc.date"));
        S2ContainerImplTest.assertEquals((String)"6", (Object)new Date(0L), (Object)root.getComponent((Object)"date"));
        S2ContainerImplTest.assertEquals((String)"7", (String)"bbb", (String)((S2Container)root.getComponent((Object)"aaa.bbb")).getNamespace());
        S2ContainerImplTest.assertEquals((String)"8", (String)"bbb", (String)((S2Container)root.getComponent((Object)"bbb")).getNamespace());
        S2ContainerImplTest.assertEquals((String)"9", (String)"ccc", (String)((S2Container)root.getComponent((Object)"bbb.ccc")).getNamespace());
        S2ContainerImplTest.assertEquals((String)"10", (String)"ccc", (String)((S2Container)root.getComponent((Object)"ccc")).getNamespace());
    }

    public void testRegisterAfterInclude() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl container2 = new S2ContainerImpl();
        S2ContainerImpl container3 = new S2ContainerImpl();
        container2.include((S2Container)container3);
        container.include((S2Container)container2);
        Date date = new Date(0L);
        container3.register((Object)date, "hoge");
        S2ContainerImplTest.assertEquals((String)"1", (Object)date, (Object)container.getComponent((Object)"hoge"));
        S2ContainerImplTest.assertEquals((String)"2", (Object)date, (Object)container.getComponent((Object)Date.class));
    }

    public void testInitAndDestroy() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        ArrayList initList = new ArrayList();
        ArrayList destroyList = new ArrayList();
        ComponentDefImpl componentDef = new ComponentDefImpl(C.class, "c1");
        componentDef.addInitMethodDef((InitMethodDef)new InitMethodDefImpl("init"));
        componentDef.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl("destroy"));
        componentDef.addArgDef((ArgDef)new ArgDefImpl((Object)"c1"));
        componentDef.addArgDef((ArgDef)new ArgDefImpl(initList));
        componentDef.addArgDef((ArgDef)new ArgDefImpl(destroyList));
        container.register((ComponentDef)componentDef);
        componentDef = new ComponentDefImpl(C.class, "c2");
        componentDef.addInitMethodDef((InitMethodDef)new InitMethodDefImpl("init"));
        componentDef.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl("destroy"));
        componentDef.addArgDef((ArgDef)new ArgDefImpl((Object)"c2"));
        componentDef.addArgDef((ArgDef)new ArgDefImpl(initList));
        componentDef.addArgDef((ArgDef)new ArgDefImpl(destroyList));
        container.register((ComponentDef)componentDef);
        componentDef = new ComponentDefImpl(C.class, "c3");
        componentDef.addInitMethodDef((InitMethodDef)new InitMethodDefImpl("init"));
        componentDef.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl("destroy"));
        componentDef.addArgDef((ArgDef)new ArgDefImpl((Object)"c3"));
        componentDef.addArgDef((ArgDef)new ArgDefImpl(initList));
        componentDef.addArgDef((ArgDef)new ArgDefImpl(destroyList));
        child.register((ComponentDef)componentDef);
        container.include((S2Container)child);
        container.init();
        S2ContainerImplTest.assertEquals((String)"1", (int)3, (int)initList.size());
        S2ContainerImplTest.assertEquals((String)"2", (Object)"c3", initList.get(0));
        S2ContainerImplTest.assertEquals((String)"3", (Object)"c1", initList.get(1));
        S2ContainerImplTest.assertEquals((String)"4", (Object)"c2", initList.get(2));
        container.destroy();
        S2ContainerImplTest.assertEquals((String)"5", (int)3, (int)destroyList.size());
        S2ContainerImplTest.assertEquals((String)"6", (Object)"c2", destroyList.get(0));
        S2ContainerImplTest.assertEquals((String)"7", (Object)"c1", destroyList.get(1));
        S2ContainerImplTest.assertEquals((String)"8", (Object)"c3", destroyList.get(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextClassLoaderWhenInit() throws Exception {
        final ClassLoader[] loader = new ClassLoader[1];
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Runnable.class);
        cd.setExpression(new Expression(){

            public Object evaluate(S2Container container, Map context) {
                return new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1)[0] = Thread.currentThread().getContextClassLoader();
                    }
                };
            }

            static /* synthetic */ ClassLoader[] access$000(1 x0) {
                return x0.loader;
            }
        });
        cd.addInitMethodDef((InitMethodDef)new InitMethodDefImpl("run"));
        container.register((ComponentDef)cd);
        ClassLoader loader1 = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader2 = new URLClassLoader(new URL[0]);
        Thread.currentThread().setContextClassLoader(loader2);
        try {
            container.init();
            S2ContainerImplTest.assertEquals((String)"1", (Object)loader1, (Object)loader[0]);
            S2ContainerImplTest.assertEquals((String)"2", (Object)loader2, (Object)Thread.currentThread().getContextClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextClassLoaderWhenDestroy() throws Exception {
        final ClassLoader[] loader = new ClassLoader[1];
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Runnable.class);
        cd.setExpression(new Expression(){

            public Object evaluate(S2Container container, Map context) {
                return new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$100(this.this$1)[0] = Thread.currentThread().getContextClassLoader();
                    }
                };
            }

            static /* synthetic */ ClassLoader[] access$100(3 x0) {
                return x0.loader;
            }
        });
        cd.addDestroyMethodDef((DestroyMethodDef)new DestroyMethodDefImpl("run"));
        container.register((ComponentDef)cd);
        container.init();
        ClassLoader loader1 = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader2 = new URLClassLoader(new URL[0]);
        Thread.currentThread().setContextClassLoader(loader2);
        try {
            container.destroy();
            S2ContainerImplTest.assertEquals((String)"1", (Object)loader1, (Object)loader[0]);
            S2ContainerImplTest.assertEquals((String)"2", (Object)loader2, (Object)Thread.currentThread().getContextClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader1);
        }
    }

    public void testInjectDependency() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl componentDef = new ComponentDefImpl(HashMap.class, "hoge");
        componentDef.setInstanceDef(InstanceDefFactory.OUTER);
        InitMethodDefImpl md = new InitMethodDefImpl("put");
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"aaa"));
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"111"));
        componentDef.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)componentDef);
        HashMap map = new HashMap();
        container.injectDependency(map);
        S2ContainerImplTest.assertEquals((String)"1", (Object)"111", map.get("aaa"));
        HashMap map2 = new HashMap();
        container.injectDependency(map2, Map.class);
        S2ContainerImplTest.assertEquals((String)"2", (Object)"111", map2.get("aaa"));
        HashMap map3 = new HashMap();
        container.injectDependency(map3, "hoge");
        S2ContainerImplTest.assertEquals((String)"3", (Object)"111", map3.get("aaa"));
    }

    public void testSelf() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(D.class);
        D d = (D)container.getComponent((Object)D.class);
        S2ContainerImplTest.assertSame((String)"1", (Object)container, (Object)d.getContainer());
    }

    public void testSelf2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(D.class);
        PropertyDefImpl pd = new PropertyDefImpl("container");
        pd.setExpression((Expression)new OgnlExpression("container"));
        cd.addPropertyDef((PropertyDef)pd);
        container.register((ComponentDef)cd);
        D d = (D)container.getComponent((Object)D.class);
        S2ContainerImplTest.assertSame((String)"1", (Object)container, (Object)d.getContainer());
    }

    public void testConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImplTest.assertEquals((String)"1", (int)0, (int)container.getComponentDefSize());
    }

    public void testNamespace() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.setNamespace("aaa");
        container.register(String.class, "bbb");
        S2ContainerImplTest.assertNotNull((String)"1", (Object)container.getComponent((Object)"bbb"));
        S2ContainerImplTest.assertNotNull((String)"2", (Object)container.getComponent((Object)"aaa.bbb"));
    }

    public void testGetComponentDef() throws Exception {
        S2ContainerImpl aaa = new S2ContainerImpl();
        aaa.setNamespace("aaa");
        S2ContainerImpl bbb = new S2ContainerImpl();
        bbb.setNamespace("bbb");
        bbb.register(String.class, "hoge");
        aaa.include((S2Container)bbb);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)aaa.getComponentDef((Object)"bbb.hoge"));
        S2ContainerImplTest.assertNotNull((String)"2", (Object)bbb.getComponentDef((Object)"bbb.hoge"));
    }

    public void testGetComponentDef2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(FooImpl.class);
        Hoge hoge = (Hoge)container.getComponent((Object)Hoge.class);
        S2ContainerImplTest.assertEquals((String)"1", (String)"Foo", (String)hoge.getName());
    }

    public void testFindComponents() throws Exception {
        Map[] found = (Map[])this.container0.findComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)1, (int)found.length);
        found = (Map[])this.container1.findComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)1, (int)found.length);
        found = (Map[])this.container2.findComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)2, (int)found.length);
        found = (Map[])this.container3.findComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)3, (int)found.length);
        found = (Map[])this.container4.findComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)4, (int)found.length);
    }

    public void testFindAllComponents() throws Exception {
        Map[] found = (Map[])this.container0.findAllComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)10, (int)found.length);
        found = (Map[])this.container1.findAllComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)10, (int)found.length);
        found = (Map[])this.container2.findAllComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)9, (int)found.length);
        found = (Map[])this.container3.findAllComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)7, (int)found.length);
        found = (Map[])this.container4.findAllComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)4, (int)found.length);
    }

    public void testFindAllComponentsPerformance() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        for (int i = 0; i < 100; ++i) {
            S2ContainerImpl child = new S2ContainerImpl();
            for (int j = 0; j < 100; ++j) {
                child.register(new HashMap());
            }
            container.include((S2Container)child);
        }
        long t1 = System.currentTimeMillis();
        Map[] found = (Map[])container.findAllComponents((Object)Map.class);
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1 + "ms");
        S2ContainerImplTest.assertEquals((int)10000, (int)found.length);
    }

    public void testFindLocalComponents() throws Exception {
        Map[] found = (Map[])this.container0.findLocalComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)0, (int)found.length);
        found = (Map[])this.container1.findLocalComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)1, (int)found.length);
        found = (Map[])this.container2.findLocalComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)2, (int)found.length);
        found = (Map[])this.container3.findLocalComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)3, (int)found.length);
        found = (Map[])this.container4.findLocalComponents((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)4, (int)found.length);
    }

    public void testFindComponentDefs() throws Exception {
        ComponentDef[] found = this.container0.findComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)1, (int)found.length);
        found = this.container1.findComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)1, (int)found.length);
        found = this.container2.findComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)2, (int)found.length);
        found = this.container3.findComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)3, (int)found.length);
        found = this.container4.findComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)4, (int)found.length);
    }

    public void testFindAllComponentDefs() throws Exception {
        ComponentDef[] found = this.container0.findAllComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)10, (int)found.length);
        found = this.container1.findAllComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)10, (int)found.length);
        found = this.container2.findAllComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)9, (int)found.length);
        found = this.container3.findAllComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)7, (int)found.length);
        found = this.container4.findAllComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)4, (int)found.length);
    }

    public void testFindLocalComponentDefs() throws Exception {
        ComponentDef[] found = this.container0.findLocalComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)0, (int)found.length);
        found = this.container1.findLocalComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)1, (int)found.length);
        found = this.container2.findLocalComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)2, (int)found.length);
        found = this.container3.findLocalComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)3, (int)found.length);
        found = this.container4.findLocalComponentDefs((Object)Map.class);
        S2ContainerImplTest.assertEquals((int)4, (int)found.length);
    }

    public void testRequest() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        child.setNamespace("aaa");
        child.register(RequestClient.class);
        container.include((S2Container)child);
        MockServletContextImpl ctx = new MockServletContextImpl("/s2jsf-example");
        MockHttpServletRequest request = ctx.createRequest("/hello.html");
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        extCtx.setRequest((Object)request);
        container.setExternalContext((ExternalContext)extCtx);
        container.setExternalContextComponentDefRegister((ExternalContextComponentDefRegister)new HttpServletExternalContextComponentDefRegister());
        container.init();
        RequestClient client = (RequestClient)container.getComponent((Object)RequestClient.class);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)client.getRequest());
    }

    public void testSession() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        child.setNamespace("aaa");
        child.register(SessionClient.class);
        container.include((S2Container)child);
        MockServletContextImpl ctx = new MockServletContextImpl("/s2jsf-example");
        MockHttpServletRequest request = ctx.createRequest("/hello.html");
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        extCtx.setRequest((Object)request);
        container.setExternalContext((ExternalContext)extCtx);
        container.setExternalContextComponentDefRegister((ExternalContextComponentDefRegister)new HttpServletExternalContextComponentDefRegister());
        container.init();
        SessionClient client = (SessionClient)container.getComponent((Object)SessionClient.class);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)client.getSession());
    }

    public void testResponse() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        child.setNamespace("aaa");
        child.register(ResponseClient.class);
        container.include((S2Container)child);
        MockServletContextImpl ctx = new MockServletContextImpl("/s2jsf-example");
        MockHttpServletRequest request = ctx.createRequest("/hello.html");
        MockHttpServletResponseImpl response = new MockHttpServletResponseImpl((HttpServletRequest)request);
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        extCtx.setResponse((Object)response);
        container.setExternalContext((ExternalContext)extCtx);
        container.setExternalContextComponentDefRegister((ExternalContextComponentDefRegister)new HttpServletExternalContextComponentDefRegister());
        container.init();
        ResponseClient client = (ResponseClient)container.getComponent((Object)ResponseClient.class);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)client.getResponse());
    }

    public void testServletContext() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        S2ContainerImpl child = new S2ContainerImpl();
        child.setNamespace("aaa");
        child.register(ServletContextClient.class);
        container.include((S2Container)child);
        MockServletContextImpl ctx = new MockServletContextImpl("/s2jsf-example");
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        extCtx.setApplication((Object)ctx);
        container.setExternalContext((ExternalContext)extCtx);
        container.setExternalContextComponentDefRegister((ExternalContextComponentDefRegister)new HttpServletExternalContextComponentDefRegister());
        container.init();
        ServletContextClient client = (ServletContextClient)container.getComponent((Object)ServletContextClient.class);
        S2ContainerImplTest.assertNotNull((String)"1", (Object)client.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOgnlClassResolvingWhileClassLoaderSpecified() throws Exception {
        block20: {
            S2ContainerImpl container = new S2ContainerImpl(){

                public ClassLoader getClassLoader() {
                    return null;
                }
            };
            ComponentDefImpl componentDef = new ComponentDefImpl();
            componentDef.setComponentName("component");
            componentDef.setExpression((Expression)new OgnlExpression("@org.seasar.framework.container.impl.S2ContainerImpl@class"));
            container.register((ComponentDef)componentDef);
            Object obj = container.getComponent((Object)"component");
            S2ContainerImplTest.assertNotNull((String)"1", (Object)obj);
            S2ContainerImplTest.assertEquals((String)"2", (Object)S2ContainerImpl.class, (Object)obj);
            File componentClassFile = ResourceUtil.getResourceAsFile((String)"org/seasar/framework/container/impl/classes/test/Component");
            File parentDir = componentClassFile.getParentFile();
            byte[] buf = new byte[4096];
            FileInputStream is = null;
            OutputStream os = null;
            File componentClassOutFile = null;
            try {
                Throwable t22;
                block18: {
                    try {
                        int len;
                        is = new FileInputStream(componentClassFile);
                        componentClassOutFile = new File(parentDir, "Component.class");
                        os = new FileOutputStream(componentClassOutFile);
                        while ((len = ((InputStream)is).read(buf)) != -1) {
                            os.write(buf, 0, len);
                        }
                        Object var12_12 = null;
                        if (os == null) break block18;
                    }
                    catch (Throwable throwable) {
                        Throwable t22;
                        Object var12_13 = null;
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable t22) {
                                // empty catch block
                            }
                        }
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable t22) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        os.close();
                    }
                    catch (Throwable t22) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable t22) {}
                }
                File classesDir = parentDir.getParentFile();
                URLClassLoader customCl = new URLClassLoader(new URL[]{classesDir.toURI().toURL()});
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(customCl);
                    container = new S2ContainerImpl();
                    componentDef = new ComponentDefImpl();
                    componentDef.setComponentName("component");
                    componentDef.setExpression((Expression)new OgnlExpression("@test.Component@class"));
                    container.register((ComponentDef)componentDef);
                    obj = container.getComponent((Object)"component");
                    S2ContainerImplTest.assertNotNull((String)"3", (Object)obj);
                    S2ContainerImplTest.assertSame((String)"4", (Object)customCl, (Object)((Class)obj).getClassLoader());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                Object var16_19 = null;
                if (componentClassOutFile == null || !componentClassOutFile.exists()) break block20;
                componentClassOutFile.delete();
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                if (componentClassOutFile != null && componentClassOutFile.exists()) {
                    componentClassOutFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    public static class ServletContextClient {
        private ServletContext servletContext_;

        public ServletContext getServletContext() {
            return this.servletContext_;
        }

        public void setServletContext(ServletContext servletContext) {
            this.servletContext_ = servletContext;
        }
    }

    public static class ResponseClient {
        private HttpServletResponse response_;

        public HttpServletResponse getResponse() {
            return this.response_;
        }

        public void setResponse(HttpServletResponse response) {
            this.response_ = response;
        }
    }

    public static class SessionClient {
        private HttpSession session_;

        public HttpSession getSession() {
            return this.session_;
        }

        public void setSession(HttpSession session) {
            this.session_ = session;
        }
    }

    public static class RequestClient {
        private HttpServletRequest request_;

        public HttpServletRequest getRequest() {
            return this.request_;
        }

        public void setRequest(HttpServletRequest request) {
            this.request_ = request;
        }
    }

    public static class FooImpl
    implements Foo {
        public String getName() {
            return "Foo";
        }
    }

    public static class D {
        private S2Container container_;

        public S2Container getContainer() {
            return this.container_;
        }

        public void setContainer(S2Container container) {
            this.container_ = container;
        }
    }

    public static class C {
        private String name_;
        private List initList_;
        private List destroyList_;

        public C(String name, List initList, List destoryList) {
            this.name_ = name;
            this.initList_ = initList;
            this.destroyList_ = destoryList;
        }

        public void init() {
            this.initList_.add(this.name_);
        }

        public void destroy() {
            this.destroyList_.add(this.name_);
        }
    }

    public static class B2
    implements Hoge {
        public String getName() {
            return "B2";
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Foo
    extends Hoge {
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A {
        private Hoge hoge_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }
}

