/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import java.util.Map;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationComponentDef;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class S2ContainerBehaviorTest
extends S2FrameworkTestCase {
    private S2Container container;

    public void setUp() throws Exception {
        this.include("S2ContainerBehaviorTest.dicon");
    }

    public void testGetComponent() throws Exception {
        S2ContainerBehaviorTest.assertNotNull((String)"1", (Object)this.container.getComponent((Object)"foo"));
        try {
            this.container.getComponent((Object)"not exists");
            S2ContainerBehaviorTest.fail((String)"2");
        }
        catch (ComponentNotFoundRuntimeException expected) {
            // empty catch block
        }
        try {
            this.container.getComponent((Object)"bar");
            S2ContainerBehaviorTest.fail((String)"3");
        }
        catch (TooManyRegistrationRuntimeException expected) {
            System.out.println((Object)expected);
        }
    }

    public void testGetComponentDef() throws Exception {
        S2ContainerBehaviorTest.assertNotNull((String)"1", (Object)this.container.getComponentDef((Object)"foo"));
        try {
            this.container.getComponentDef((Object)"not exists");
            S2ContainerBehaviorTest.fail((String)"2");
        }
        catch (ComponentNotFoundRuntimeException componentNotFoundRuntimeException) {
            // empty catch block
        }
        S2ContainerBehaviorTest.assertTrue((String)"3", (boolean)(this.container.getComponentDef((Object)"bar") instanceof TooManyRegistrationComponentDef));
    }

    public void testHasComponentDef() throws Exception {
        S2ContainerBehaviorTest.assertTrue((String)"1", (boolean)this.container.hasComponentDef((Object)"foo"));
        S2ContainerBehaviorTest.assertFalse((String)"2", (boolean)this.container.hasComponentDef((Object)"not exists"));
        S2ContainerBehaviorTest.assertTrue((String)"3", (boolean)this.container.hasComponentDef((Object)"bar"));
    }

    public void testInjectDependency() throws Exception {
        Outer outer = new Outer();
        this.container.injectDependency((Object)outer, "outerFoo");
        S2ContainerBehaviorTest.assertNotNull((String)"1", (Object)outer.getMap());
        try {
            this.container.injectDependency((Object)outer, "not exists");
            S2ContainerBehaviorTest.fail((String)"2");
        }
        catch (ComponentNotFoundRuntimeException expected) {
            // empty catch block
        }
        try {
            this.container.injectDependency((Object)outer, "outerBar");
            S2ContainerBehaviorTest.fail((String)"3");
        }
        catch (UnsupportedOperationException expected) {
            System.out.println(expected);
        }
    }

    public static class Outer {
        Map map;

        public Map getMap() {
            return this.map;
        }

        public void setMap(Map map) {
            this.map = map;
        }
    }
}

