/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import junit.framework.TestCase;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;

public class ArgDefImplTest
extends TestCase {
    public void testSetExpression() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        ArgDefImpl ad = new ArgDefImpl();
        ad.setExpression((Expression)new OgnlExpression("hoge"));
        cd.addArgDef((ArgDef)ad);
        container.register((ComponentDef)cd);
        ComponentDefImpl cd2 = new ComponentDefImpl(B.class, "hoge");
        container.register((ComponentDef)cd2);
        container.register(C.class);
        A a = (A)container.getComponent((Object)A.class);
        ArgDefImplTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testSetChildComponentDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        ArgDefImpl ad = new ArgDefImpl();
        ComponentDefImpl cd2 = new ComponentDefImpl(B.class);
        ad.setChildComponentDef((ComponentDef)cd2);
        cd.addArgDef((ArgDef)ad);
        container.register((ComponentDef)cd);
        container.register(C.class);
        A a = (A)container.getComponent((Object)A.class);
        ArgDefImplTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testPrototype() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(StrHolderImpl.class, "foo");
        cd.setInstanceDef(InstanceDefFactory.PROTOTYPE);
        ComponentDefImpl cd2 = new ComponentDefImpl(StrFacadeImpl.class);
        cd2.setInstanceDef(InstanceDefFactory.PROTOTYPE);
        ArgDefImpl ad = new ArgDefImpl();
        ad.setExpression((Expression)new OgnlExpression("foo"));
        cd2.addArgDef((ArgDef)ad);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        StrFacade facade1 = (StrFacade)container.getComponent((Object)StrFacade.class);
        StrFacade facade2 = (StrFacade)container.getComponent((Object)StrFacade.class);
        facade1.setStr("aaa");
        facade2.setStr("bbb");
        ArgDefImplTest.assertEquals((String)"1", (String)"aaa", (String)facade1.getStr());
        ArgDefImplTest.assertEquals((String)"2", (String)"bbb", (String)facade2.getStr());
    }

    public static class StrFacadeImpl
    implements StrFacade {
        private StrHolder strHolder_;

        public StrFacadeImpl(StrHolder strHolder) {
            this.strHolder_ = strHolder;
        }

        public void setStr(String str) {
            this.strHolder_.setStr(str);
        }

        public String getStr() {
            return this.strHolder_.getStr();
        }
    }

    public static interface StrFacade {
        public void setStr(String var1);

        public String getStr();
    }

    public static class StrHolderImpl
    implements StrHolder {
        private String str_;

        public void setStr(String str) {
            this.str_ = str;
        }

        public String getStr() {
            return this.str_;
        }
    }

    public static interface StrHolder {
        public void setStr(String var1);

        public String getStr();
    }

    public static class C
    implements Hoge {
        private A2 a2_;

        public void setA2(A2 a2) {
            this.a2_ = a2;
        }

        public String getName() {
            return "C";
        }

        public String getHogeName() {
            return this.a2_.getHogeName();
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A2 {
        private Hoge hoge_;

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static class A {
        private Hoge hoge_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }
}

