/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.hotdeploy.HotdeployHttpServletRequest;
import org.seasar.framework.container.hotdeploy.HotdeployHttpSession;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.SessionObjectNotSerializableRuntimeException;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class HotdeployHttpSessionTest
extends S2FrameworkTestCase {
    ClassLoader originalClassLoader;
    static /* synthetic */ Class class$org$seasar$framework$container$hotdeploy$HotdeployHttpSession;

    protected void setUp() throws Exception {
        super.setUp();
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }

    protected void tearDown() throws Exception {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        super.tearDown();
    }

    public void test() throws Exception {
        ChildFirstClassLoader oldCl = new ChildFirstClassLoader(this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(oldCl);
        Class<?> fooClass = oldCl.loadClass(Foo.class.getName());
        Object oldFoo = fooClass.newInstance();
        HotdeployHttpSessionTest.assertEquals((String)Foo.class.getName(), (String)oldFoo.getClass().getName());
        HotdeployHttpSessionTest.assertEquals((Object)oldCl, (Object)oldFoo.getClass().getClassLoader());
        HotdeployHttpSession session = new HotdeployHttpSession(null, this.getRequest().getSession());
        session.setAttribute("foo", oldFoo);
        HotdeployHttpSessionTest.assertSame(oldFoo, (Object)session.getAttribute("foo"));
        session.flush();
        ChildFirstClassLoader newCl = new ChildFirstClassLoader(this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(newCl);
        session = new HotdeployHttpSession(null, this.getRequest().getSession());
        Object newFoo = session.getAttribute("foo");
        HotdeployHttpSessionTest.assertNotSame(oldFoo, (Object)newFoo);
        HotdeployHttpSessionTest.assertSame((Object)newFoo, (Object)session.getAttribute("foo"));
        HotdeployHttpSessionTest.assertEquals((String)Foo.class.getName(), (String)newFoo.getClass().getName());
        HotdeployHttpSessionTest.assertEquals((Object)newCl, (Object)newFoo.getClass().getClassLoader());
    }

    public void testNotSerializable() throws Exception {
        HotdeployHttpSession session = new HotdeployHttpSession(null, this.getRequest().getSession());
        try {
            session.setAttribute("bar", (Object)new Bar());
            HotdeployHttpSessionTest.fail();
        }
        catch (SessionObjectNotSerializableRuntimeException expected) {
            expected.printStackTrace();
        }
    }

    public void testInvalidate() throws Exception {
        HotdeployHttpServletRequest request = new HotdeployHttpServletRequest((HttpServletRequest)this.getRequest());
        HttpSession s1 = request.getSession();
        s1.setAttribute("a", (Object)"1");
        s1.invalidate();
        try {
            s1.getAttribute("a");
            HotdeployHttpSessionTest.fail();
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        HttpSession s2 = request.getSession();
        HotdeployHttpSessionTest.assertNotSame((Object)s1, (Object)s2);
    }

    public static class Bar {
    }

    public static class Foo
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }

    public static class ChildFirstClassLoader
    extends ClassLoader {
        public ChildFirstClassLoader(ClassLoader parent) {
            super(parent);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!name.startsWith((class$org$seasar$framework$container$hotdeploy$HotdeployHttpSession == null ? (class$org$seasar$framework$container$hotdeploy$HotdeployHttpSession = HotdeployHttpSessionTest.class$("org.seasar.framework.container.hotdeploy.HotdeployHttpSession")) : class$org$seasar$framework$container$hotdeploy$HotdeployHttpSession).getName()) && !name.equals("org.seasar.framework.container.hotdeploy.HotdeployUtil$RebuilderImpl")) {
                return super.loadClass(name, resolve);
            }
            InputStream is = this.getParent().getResourceAsStream(name.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }
}

