/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import junit.framework.TestCase;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.util.ClassUtil;

public class HotdeployClassLoaderTest
extends TestCase {
    private static String PACKAGE_NAME = ClassUtil.getPackageName((Class)HotdeployClassLoaderTest.class) + ".sub";
    private static String AAA_NAME = PACKAGE_NAME + ".Aaa";
    private ClassLoader originalLoader;
    private HotdeployClassLoader hotLoader;

    protected void setUp() {
        this.originalLoader = Thread.currentThread().getContextClassLoader();
        NamingConventionImpl convention = new NamingConventionImpl();
        convention.addRootPackageName(PACKAGE_NAME);
        convention.addRootPackageName("junit.framework");
        convention.addRootPackageName("javassist", false);
        this.hotLoader = new HotdeployClassLoader(this.originalLoader, (NamingConvention)convention);
        Thread.currentThread().setContextClassLoader((ClassLoader)this.hotLoader);
    }

    protected void tearDown() {
        Thread.currentThread().setContextClassLoader(this.originalLoader);
    }

    public void testLoadClass() throws Exception {
        HotdeployClassLoaderTest.assertTrue((boolean)this.hotLoader.isTargetClass("junit.framework.TestCase"));
        HotdeployClassLoaderTest.assertFalse((boolean)this.hotLoader.isTargetClass("javassist.CtClass"));
        HotdeployClassLoaderTest.assertSame((Object)this.hotLoader.loadClass(AAA_NAME), (Object)this.hotLoader.loadClass(AAA_NAME));
        Class clazz = this.hotLoader.loadClass("junit.framework.TestCase");
        HotdeployClassLoaderTest.assertEquals((Object)TestCase.class, (Object)clazz);
        Class.forName(HotdeployUtil.Rebuilder.class.getName());
        clazz = this.hotLoader.loadClass("org.seasar.framework.container.hotdeploy.HotdeployUtil$RebuilderImpl");
        HotdeployClassLoaderTest.assertSame((Object)this.hotLoader, (Object)clazz.getClassLoader());
        HotdeployClassLoaderTest.assertSame((Object)HotdeployUtil.Rebuilder.class, clazz.getInterfaces()[0]);
        HotdeployClassLoaderTest.assertTrue((boolean)HotdeployUtil.Rebuilder.class.isAssignableFrom(clazz));
        HotdeployUtil.Rebuilder rebuilder = (HotdeployUtil.Rebuilder)clazz.newInstance();
        HotdeployClassLoaderTest.assertNotNull((Object)rebuilder);
        HotdeployClassLoaderTest.assertSame((Object)clazz, (Object)this.hotLoader.loadClass("org.seasar.framework.container.hotdeploy.HotdeployUtil$RebuilderImpl"));
        try {
            this.hotLoader.loadClass(PACKAGE_NAME + ".xxx");
            HotdeployClassLoaderTest.fail();
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex);
        }
    }
}

