/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.creator.ComponentCreatorImpl;
import org.seasar.framework.container.hotdeploy.HotdeployBehavior;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.framework.util.ClassUtil;

public class HotdeployBehaviorTest
extends S2FrameworkTestCase {
    private ClassLoader originalLoader;
    private HotdeployBehavior ondemand;
    private String rootPackageName = ClassUtil.getPackageName(((Object)((Object)this)).getClass()) + ".creator";

    protected void setUp() {
        this.originalLoader = Thread.currentThread().getContextClassLoader();
        NamingConventionImpl convention = new NamingConventionImpl();
        convention.addRootPackageName(this.rootPackageName);
        this.ondemand = new HotdeployBehavior();
        this.ondemand.setNamingConvention((NamingConvention)convention);
        ComponentCreatorImpl creator = new ComponentCreatorImpl((NamingConvention)convention);
        creator.setNameSuffix("Dao");
        this.ondemand.setCreators(new ComponentCreator[]{creator});
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)this.ondemand);
    }

    protected void tearDown() {
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new S2ContainerBehavior.DefaultProvider());
        Thread.currentThread().setContextClassLoader(this.originalLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartStop() throws Exception {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(((Object)((Object)this)).getClass());
        this.ondemand.start();
        try {
            HotdeployBehaviorTest.assertEquals((Object)HotdeployClassLoader.class, Thread.currentThread().getContextClassLoader().getClass());
        }
        finally {
            this.ondemand.stop();
        }
        HotdeployBehaviorTest.assertSame((Object)this.originalLoader, (Object)Thread.currentThread().getContextClassLoader());
        HotdeployBehaviorTest.assertNotSame((Object)beanDesc, (Object)BeanDescFactory.getBeanDesc(((Object)((Object)this)).getClass()));
    }
}

