/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.File;
import java.net.URL;
import junit.framework.TestCase;
import org.seasar.framework.container.factory.ClassPathResourceResolver;
import org.seasar.framework.env.Env;
import org.seasar.framework.util.ResourceUtil;

public class ClassPathResourceResolverTest
extends TestCase {
    private static final String PATH = "org/seasar/framework/container/factory/ClassPathResourceResolverTest.dicon";
    private static final String PATH2 = "org/seasar/framework/container/factory/aaa.dicon";
    private static final String ENV_PATH = "org/seasar/framework/container/factory/env.txt";
    private ClassPathResourceResolver target = new ClassPathResourceResolver();

    protected void tearDown() {
        Env.initialize();
    }

    public void testToURL1() throws Exception {
        URL actual = this.target.toURL(PATH);
        ClassPathResourceResolverTest.assertNotNull((Object)actual);
        ClassPathResourceResolverTest.assertEquals((Object)((Object)((Object)this)).getClass().getClassLoader().getResource(PATH), (Object)actual);
    }

    public void testToURL2() throws Exception {
        URL expected = new File(ResourceUtil.getBuildDir(((Object)((Object)this)).getClass()), PATH).toURI().toURL();
        URL actual = this.target.toURL(expected.toExternalForm());
        ClassPathResourceResolverTest.assertNotNull((Object)actual);
        ClassPathResourceResolverTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testGetURL() throws Exception {
        URL url = this.target.getURL(PATH2);
        System.out.println(url.getPath());
        ClassPathResourceResolverTest.assertTrue((boolean)url.getPath().endsWith("aaa.dicon"));
        Env.setFilePath((String)ENV_PATH);
        url = this.target.getURL(PATH2);
        System.out.println(url.getPath());
        ClassPathResourceResolverTest.assertTrue((boolean)url.getPath().endsWith("aaa_ut.dicon"));
    }
}

