/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class HttpServletExternalContextTest
extends S2FrameworkTestCase {
    public void testGetRequestCookieMap() {
        MockHttpServletRequest request = this.getRequest();
        Cookie cookie = new Cookie("a", "A");
        request.addCookie(cookie);
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest((Object)request);
        Map map = context.getRequestCookieMap();
        HttpServletExternalContextTest.assertSame((Object)map, (Object)context.getRequestCookieMap());
        HttpServletExternalContextTest.assertTrue((boolean)map.containsKey("a"));
        HttpServletExternalContextTest.assertTrue((boolean)map.containsValue("A"));
        HttpServletExternalContextTest.assertFalse((boolean)map.isEmpty());
        HttpServletExternalContextTest.assertEquals((int)1, (int)map.size());
    }

    public void testGetRequestCookieMap_requestNull() {
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest(null);
        Map map = context.getRequestCookieMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
        try {
            map.put("a", "b");
            HttpServletExternalContextTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetSessionMap() {
        MockHttpServletRequest request = this.getRequest();
        HttpSession session = request.getSession();
        session.setAttribute("aaa", (Object)"bbb");
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest((Object)request);
        Map map = context.getSessionMap();
        HttpServletExternalContextTest.assertEquals((Object)"bbb", map.get("aaa"));
        HttpServletExternalContextTest.assertEquals((int)1, (int)map.size());
        map.remove("aaa");
        HttpServletExternalContextTest.assertNull(map.get("aaa"));
        map.put("bbb", "ccc");
        HttpServletExternalContextTest.assertEquals((Object)"ccc", (Object)session.getAttribute("bbb"));
    }

    public void testGetSessionMap_requestNull() {
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest(null);
        Map map = context.getSessionMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
        map.put("a", "b");
    }

    public void testGetApplicationMap() {
        MockServletContext context = this.getServletContext();
        context.setAttribute("a", (Object)"A");
        HttpServletExternalContext extContext = new HttpServletExternalContext();
        extContext.setApplication((Object)context);
        Map map = extContext.getApplicationMap();
        HttpServletExternalContextTest.assertEquals((Object)"A", map.get("a"));
        HttpServletExternalContextTest.assertEquals((int)1, (int)map.size());
        map.put("a", "B");
        HttpServletExternalContextTest.assertEquals((Object)"B", map.get("a"));
        map.clear();
        HttpServletExternalContextTest.assertNull(map.get("a"));
        context.setAttribute("b", (Object)"B");
        HttpServletExternalContextTest.assertEquals((Object)"B", map.get("b"));
        context.removeAttribute("b");
        HttpServletExternalContextTest.assertNull(map.get("b"));
    }

    public void testGetApplicationMap_requestNull() {
        MockServletContext sc = this.getServletContext();
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setApplication((Object)sc);
        Map map = context.getApplicationMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
    }

    public void testGetInitParameterMap() {
        MockServletContextImpl context = new MockServletContextImpl(null);
        context.setInitParameter("a", "A");
        HttpServletExternalContext extContext = new HttpServletExternalContext();
        extContext.setApplication((Object)context);
        Map map = extContext.getInitParameterMap();
        HttpServletExternalContextTest.assertEquals((Object)"A", map.get("a"));
        HttpServletExternalContextTest.assertEquals((int)1, (int)map.size());
        try {
            map.put("b", "B");
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            map.remove("b");
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            map.clear();
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void testGetInitParameterMap_requestNull() {
        MockServletContext sc = this.getServletContext();
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setApplication((Object)sc);
        Map map = context.getInitParameterMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
    }

    public void testGetRequestHeaderMap() {
        MockHttpServletRequest request = this.getRequest();
        request.addHeader("a", "A");
        HttpServletExternalContext extContext = new HttpServletExternalContext();
        extContext.setRequest((Object)request);
        Map map = extContext.getRequestHeaderMap();
        HttpServletExternalContextTest.assertSame((Object)map, (Object)extContext.getRequestHeaderMap());
        HttpServletExternalContextTest.assertEquals((Object)"A", map.get("a"));
        HttpServletExternalContextTest.assertEquals((int)1, (int)map.size());
        try {
            map.put("b", "B");
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            map.remove("b");
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            map.clear();
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void testGetRequestHeaderMap_requestNull() {
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest(null);
        Map map = context.getRequestHeaderMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
        try {
            map.put("a", "b");
            HttpServletExternalContextTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetRequestHeaderValuesMap() {
        MockHttpServletRequest request = this.getRequest();
        request.addHeader("a", "A");
        request.addHeader("a", "B");
        HttpServletExternalContext extContext = new HttpServletExternalContext();
        extContext.setRequest((Object)request);
        Map map = extContext.getRequestHeaderValuesMap();
        HttpServletExternalContextTest.assertSame((Object)map, (Object)extContext.getRequestHeaderValuesMap());
        Object o = map.get("a");
        HttpServletExternalContextTest.assertNotNull(o);
        HttpServletExternalContextTest.assertTrue((boolean)(o instanceof String[]));
        String[] strs = (String[])o;
        HttpServletExternalContextTest.assertEquals((int)2, (int)strs.length);
        HttpServletExternalContextTest.assertEquals((String)"A", (String)strs[0]);
        HttpServletExternalContextTest.assertEquals((String)"B", (String)strs[1]);
    }

    public void testGetRequestHeaderValuesMap_requestNull() {
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest(null);
        Map map = context.getRequestHeaderValuesMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
        try {
            map.put("a", "b");
            HttpServletExternalContextTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetRequestMap() {
        MockHttpServletRequest request = this.getRequest();
        request.setAttribute("hoge", (Object)"foo");
        HttpServletExternalContext extContext = new HttpServletExternalContext();
        extContext.setRequest((Object)request);
        Map map = extContext.getRequestMap();
        HttpServletExternalContextTest.assertSame((Object)map, (Object)extContext.getRequestMap());
        HttpServletExternalContextTest.assertEquals((Object)"foo", map.get("hoge"));
        map.put("bar", "baz");
        HttpServletExternalContextTest.assertEquals((Object)"baz", (Object)request.getAttribute("bar"));
        map.remove("baz");
        HttpServletExternalContextTest.assertNull(map.get("baz"));
    }

    public void testGetRequestMap_requestNull() {
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest(null);
        Map map = context.getRequestMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
        map.put("a", "b");
    }

    public void testGetRequestParameterMap() {
        MockHttpServletRequest request = this.getRequest();
        request.setParameter("a", "A");
        HttpServletExternalContext extContext = new HttpServletExternalContext();
        extContext.setRequest((Object)request);
        HttpServletExternalContextTest.assertSame((Object)HttpServletExternalContext.LAZY_MARK, extContext.requestParameterMaps.get());
        Map map = extContext.getRequestParameterMap();
        HttpServletExternalContextTest.assertSame((Object)map, (Object)extContext.getRequestParameterMap());
        HttpServletExternalContextTest.assertEquals((Object)"A", map.get("a"));
        HttpServletExternalContextTest.assertEquals((int)1, (int)map.size());
        try {
            map.put("b", "B");
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            map.remove("b");
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            map.clear();
            HttpServletExternalContextTest.fail();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void testGetRequestParameterMap_requestNull() {
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest(null);
        HttpServletExternalContextTest.assertNotNull(context.requestParameterMaps.get());
        Map map = context.getRequestParameterMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
        try {
            map.put("a", "b");
            HttpServletExternalContextTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetRequestParameterValuesMap() {
        MockHttpServletRequest request = this.getRequest();
        request.setParameter("a", new String[]{"A", "B"});
        HttpServletExternalContext extContext = new HttpServletExternalContext();
        extContext.setRequest((Object)request);
        HttpServletExternalContextTest.assertSame((Object)HttpServletExternalContext.LAZY_MARK, extContext.requestParameterValuesMaps.get());
        Map map = extContext.getRequestParameterValuesMap();
        HttpServletExternalContextTest.assertSame((Object)map, (Object)extContext.getRequestParameterValuesMap());
        Object o = map.get("a");
        HttpServletExternalContextTest.assertNotNull(o);
        HttpServletExternalContextTest.assertTrue((boolean)(o instanceof String[]));
        String[] strs = (String[])o;
        HttpServletExternalContextTest.assertEquals((int)2, (int)strs.length);
        HttpServletExternalContextTest.assertEquals((String)"A", (String)strs[0]);
        HttpServletExternalContextTest.assertEquals((String)"B", (String)strs[1]);
    }

    public void testGetRequestParameterValuesMap_requestNull() {
        HttpServletExternalContext context = new HttpServletExternalContext();
        context.setRequest(null);
        HttpServletExternalContextTest.assertNotNull(context.requestParameterValuesMaps.get());
        Map map = context.getRequestParameterValuesMap();
        HttpServletExternalContextTest.assertNotNull((Object)map);
        HttpServletExternalContextTest.assertEquals((int)0, (int)map.size());
        try {
            map.put("a", "b");
            HttpServletExternalContextTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

