/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import java.math.BigDecimal;
import java.util.HashMap;
import junit.framework.TestCase;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.SingletonComponentDeployer;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class SingletonComponentDeployerTest
extends TestCase {
    public void testDeployAutoAutoConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A a = (A)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
        SingletonComponentDeployerTest.assertSame((String)"2", (Object)a, (Object)deployer.deploy());
    }

    public void testDeployAutoAutoConstructorAndProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        cd.addPropertyDef((PropertyDef)new PropertyDefImpl("aaa", (Object)new Integer(1)));
        container.register((ComponentDef)cd);
        container.register(B.class);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A a = (A)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
        SingletonComponentDeployerTest.assertEquals((String)"2", (int)1, (int)a.getAaa());
        SingletonComponentDeployerTest.assertSame((String)"3", (Object)a, (Object)deployer.deploy());
    }

    public void testDeployAutoAutoConstructorAndProperty2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        cd.addPropertyDef((PropertyDef)new PropertyDefImpl("aaa", (Object)new Integer(1)));
        container.register((ComponentDef)cd);
        container.register(B.class);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A2 a2 = (A2)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
        SingletonComponentDeployerTest.assertEquals((String)"2", (int)1, (int)a2.getAaa());
    }

    public void testDeployAutoAutoProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A2 a2 = (A2)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
    }

    public void testDeployAutoManualConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(BigDecimal.class);
        cd.addArgDef((ArgDef)new ArgDefImpl((Object)"123"));
        container.register((ComponentDef)cd);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        SingletonComponentDeployerTest.assertEquals((String)"1", (Object)new BigDecimal(123.0), (Object)deployer.deploy());
    }

    public void testDeployAutoManualProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        cd.addPropertyDef((PropertyDef)new PropertyDefImpl("hoge", (Object)new B()));
        container.register((ComponentDef)cd);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A2 a2 = (A2)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
    }

    public void testDeployAutoManual() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(D.class);
        cd.addArgDef((ArgDef)new ArgDefImpl((Object)"abc"));
        cd.addPropertyDef((PropertyDef)new PropertyDefImpl("aaa", (Object)new Integer(1)));
        container.register((ComponentDef)cd);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        D d = (D)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"abc", (String)d.getName());
        SingletonComponentDeployerTest.assertEquals((String)"2", (int)1, (int)d.getAaa());
    }

    public void testGetComponentForInitMethodDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        InitMethodDefImpl md = new InitMethodDefImpl("put");
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"aaa"));
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"hoge"));
        cd.addInitMethodDef((InitMethodDef)md);
        container.register((ComponentDef)cd);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        HashMap myMap = (HashMap)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (Object)"hoge", myMap.get("aaa"));
    }

    public void testCyclicReference() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        ComponentDefImpl cd2 = new ComponentDefImpl(C.class);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        SingletonComponentDeployer deployer2 = new SingletonComponentDeployer((ComponentDef)cd2);
        A2 a2 = (A2)deployer.deploy();
        C c = (C)deployer2.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"C", (String)a2.getHogeName());
        SingletonComponentDeployerTest.assertEquals((String)"2", (String)"C", (String)c.getHogeName());
    }

    public void testCyclicReferenceFail() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        ComponentDefImpl cd2 = new ComponentDefImpl(C2.class);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        SingletonComponentDeployer deployer2 = new SingletonComponentDeployer((ComponentDef)cd2);
        try {
            deployer.deploy();
            SingletonComponentDeployerTest.fail((String)"1");
        }
        catch (Exception expected) {
            // empty catch block
        }
        deployer2.deploy();
    }

    public void testDeployConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.CONSTRUCTOR);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A a = (A)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testDeployProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.PROPERTY);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A2 a2 = (A2)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
    }

    public void testDeployNoneManualConstructor() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(BigDecimal.class);
        cd.addArgDef((ArgDef)new ArgDefImpl((Object)"123"));
        container.register((ComponentDef)cd);
        cd.setAutoBindingDef(AutoBindingDefFactory.NONE);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        SingletonComponentDeployerTest.assertEquals((String)"1", (Object)new BigDecimal(123.0), (Object)deployer.deploy());
    }

    public void testDeployNoneManualProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        cd.addPropertyDef((PropertyDef)new PropertyDefImpl("hoge", (Object)new B()));
        container.register((ComponentDef)cd);
        cd.setAutoBindingDef(AutoBindingDefFactory.NONE);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        A2 a2 = (A2)deployer.deploy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
    }

    public void testDeployNoneDefault() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(String.class);
        container.register((ComponentDef)cd);
        cd.setAutoBindingDef(AutoBindingDefFactory.NONE);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        SingletonComponentDeployerTest.assertEquals((String)"1", (Object)"", (Object)deployer.deploy());
    }

    public void testDestroy() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        DestroyMethodDefImpl md = new DestroyMethodDefImpl("put");
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"aaa"));
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"hoge"));
        cd.addDestroyMethodDef((DestroyMethodDef)md);
        container.register((ComponentDef)cd);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        HashMap myMap = (HashMap)deployer.deploy();
        deployer.destroy();
        SingletonComponentDeployerTest.assertEquals((String)"1", (Object)"hoge", myMap.get("aaa"));
    }

    public void testInjectDependency() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        container.register((ComponentDef)cd);
        SingletonComponentDeployer deployer = new SingletonComponentDeployer((ComponentDef)cd);
        try {
            deployer.injectDependency(new HashMap());
            SingletonComponentDeployerTest.fail((String)"1");
        }
        catch (UnsupportedOperationException ex) {
            System.out.println(ex);
        }
    }

    public static class D
    implements Hoge {
        private String name_;
        private int aaa_;

        public D(String name) {
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }

        public int getAaa() {
            return this.aaa_;
        }

        public void setAaa(int aaa) {
            this.aaa_ = aaa;
        }
    }

    public static class C2
    implements Hoge {
        private static boolean firstTime;
        private Foo foo_;

        public C2() {
            if (!firstTime) {
                firstTime = true;
                throw new RuntimeException("C2");
            }
        }

        public void setFoo(Foo foo) {
            this.foo_ = foo;
        }

        public String getName() {
            return "C";
        }

        public String getHogeName() {
            return this.foo_.getHogeName();
        }
    }

    public static class C
    implements Hoge {
        private Foo foo_;

        public void setFoo(Foo foo) {
            this.foo_ = foo;
        }

        public String getName() {
            return "C";
        }

        public String getHogeName() {
            return this.foo_.getHogeName();
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A2
    implements Foo {
        private Hoge hoge_;
        private int aaa_;

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }

        public int getAaa() {
            return this.aaa_;
        }

        public void setAaa(int aaa) {
            this.aaa_ = aaa;
        }
    }

    public static class A {
        private Hoge hoge_;
        private int aaa_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }

        public int getAaa() {
            return this.aaa_;
        }

        public void setAaa(int aaa) {
            this.aaa_ = aaa;
        }
    }

    public static class FooImpl
    implements Foo {
        public String getHogeName() {
            return "hoge";
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

